/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RESOURCE_TYPES_H
#define RESOURCE_TYPES_H

#include <libpandora/global.h>

#include <libpandora/resource.h>
#include <libpandora/text.h>
#include <libpandora/url.h>

class string_resource_t : public resource_t
{
private:
  text str;

public:
  string_resource_t(const text &s) : resource_t(chars), str(s) { }
  ~string_resource_t(void) { }
  inline string_resource_t(const string_resource_t &x);
  inline string_resource_t &operator =(const string_resource_t &x);
  
  virtual bool doFetchString(char **);
  virtual bool doFetchFile(char *, int);
  virtual bool isModified(void) { return (last_fetch == 0); }
};

string_resource_t::string_resource_t(const string_resource_t &x) 
  : resource_t(x), str(x.str)
{
}

string_resource_t &string_resource_t::operator =(const string_resource_t &x)
{
  resource_t::operator=(x);
  str = x.str;
  return *this;
}



class file_resource_t : public resource_t
{
private:
  text path;

public:
  file_resource_t(const text &p) : resource_t(file), path(p) { }
  ~file_resource_t(void) { }
  inline file_resource_t(const file_resource_t &x);
  inline file_resource_t &operator =(const file_resource_t &x);
  
  virtual bool doFetchString(char **);
  virtual bool doFetchFile(char *, int);
  virtual bool isModified(void);
};

file_resource_t::file_resource_t(const file_resource_t &x) 
  : resource_t(x), path(x.path)
{
}

file_resource_t &file_resource_t::operator =(const file_resource_t &x)
{
  resource_t::operator=(x);
  path = x.path;
  return *this;
}



class http_resource_t : public resource_t
{
private:
  URL url;

public:
  http_resource_t(const text &u) : resource_t(http), url(u.data()) { }
  ~http_resource_t(void) { }
  inline http_resource_t(const http_resource_t &x);
  inline http_resource_t &operator =(const http_resource_t &x);
  
  virtual bool doFetchString(char **);
  virtual bool doFetchFile(char *, int);
  virtual bool isModified(void) { return url.ifModifiedSince(last_fetch); }
};

http_resource_t::http_resource_t(const http_resource_t &x) 
  : resource_t(x), url(x.url)
{
}

http_resource_t &http_resource_t::operator =(const http_resource_t &x)
{
  resource_t::operator=(x);
  url = x.url;
  return *this;
}

#endif /* RESOURCE_TYPES_H */
