/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef QUAD_KEY_H
#define QUAD_KEY_H

#include <libpandora/global.h>
#include <libpandora/dmxkey.h>

class QuadKey : public DmxKey {
private:
  long k1, k2, k3, k4;
  key_init(QuadKey);

public:
  inline QuadKey(void);
  inline QuadKey(long xk1, long xk2, long xk3, long xk4);
  virtual ~QuadKey(void) { }

  inline void set(long xk1, long xk2, long xk3, long xk4);
  inline long hash(void) const;

private:
  inline bool _equal(const DmxKey *x) const;
};

QuadKey::QuadKey(void) 
  : k1(0), k2(0), k3(0), k4(0) 
{ 
}

QuadKey::QuadKey(long xk1, long xk2, long xk3, long xk4) 
  : k1(xk1), k2(xk2), k3(xk3), k4(xk4) 
{ 
}

void QuadKey::set(long xk1, long xk2, long xk3, long xk4) 
{
  k1 = xk1; 
  k2 = xk2; 
  k3 = xk3; 
  k4 = xk4;
}

#define ROT(v, r) ((v)<<(r) | ((unsigned)(v))>>(32-(r)))
long QuadKey::hash(void) const 
{
#if 0
    return (k1 ^ k2 ^ k3 ^ k4);
#else
    //return (ROT(k1, k3%16) ^ ROT(k2, 31-k4%16)) ^ ((k4 << 16) | k3);
    return (ROT(k1, 13) ^ ROT(k2, 23) ^ (k3 | (k4 << 16)));
#endif
}
#undef ROT

bool QuadKey::_equal(const DmxKey *_x) const 
{
  const QuadKey *x = (const QuadKey *)_x;
  return ((k4 == x->k4) & (k3 == x->k3) & (k2 == x->k2) & (k1 == x->k1));
}

#endif /* QUAD_KEY_H */
