/* Copyright (C) 1999, 2000, 2001, 2002 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/error.h>
#include <libpandora/pktutil.h>
#include <libpandora/netutil.h>

#define HEADER_LENGTH	(sizeof(short))

int packet_send(Packet *pkt, int fd, char *temp, size_t maxlen)
{
  if (fd < 0) return -1;

  size_t len = HEADER_LENGTH;
  serialize(temp, len, maxlen, &pkt);
  short tmps = htons((short)len);
  memcpy(temp, (char *) &tmps, HEADER_LENGTH);      

  int n =  net_writeblock(fd, temp, len);
  
  return n;
}

int packet_recv(Packet * &pkt, int fd, char *temp, size_t maxlen)
{
  if (fd < 0) return -1;

  int nbytes = 0;
  short length;
  nbytes = recvfrom(fd, (char *)&length, HEADER_LENGTH, MSG_PEEK|MSG_NOSIGNAL,
		    NULL, 0);
  if (nbytes < (int)HEADER_LENGTH) {
    return -1;
  }
  length = ntohs(length);
  pandora_assert(length > 0);

  if (length > (int)maxlen) {
    return -1;
  }

  nbytes = net_readblock(fd, temp, length);
  if (nbytes != length) return -1;
  
  size_t len = 0;
  unserialize((temp + HEADER_LENGTH), len, &pkt);

  return len;
}

int packet_send(Packet *pkt, FILE *f, char *temp, size_t maxlen)
{
  if (f == NULL) return -1;

  size_t len = HEADER_LENGTH;
  serialize(temp, len, maxlen, &pkt);
  short tmps = htons(len);
  memcpy(temp, (char *) &tmps, HEADER_LENGTH);      

  if (fwrite(temp, sizeof(char), len, f) < len) return -1;
  return (int)len;
}

int packet_recv(Packet * &pkt, FILE *f, char *temp, size_t maxlen)
{
  if (f == NULL) return -1;
  if (feof(f))   return -1;

  int nobj = 0;
  short length = 0;
  nobj = fread((char *)&length, 1, HEADER_LENGTH, f);
  if (nobj < (int)HEADER_LENGTH) {
    //pandora_pwarning("fread:length");
    return -1;
  }
  length = ntohs(length);
  pandora_assert(length > 0);
  
  if (length > (int)maxlen) {
    pandora_pwarning("maxlen exceeded");
    return -1;
  }
  nobj = fread(temp + HEADER_LENGTH, 1, length - HEADER_LENGTH, f);
  if (nobj < (int)(length - HEADER_LENGTH)) {
    pandora_pwarning("fread");
    return -1;
  }
  
  size_t len = 0;
  unserialize((temp + HEADER_LENGTH), len, &pkt);

  return len;
}

