/* Copyright (C) 1999, 2000, 2001, 2002 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/pandoraentry.h>
#include <libpandora/stackentry.h>
#include <libpandora/compentry.h>
#include <libpandora/optionentry.h>

void PandoraEntry::reset(void) 
{ 
  __DELETE(se);
  __DELETE(ce);
  __DELETE(oe);
}

void PandoraEntry::setStack(StackEntry *s)
{
  if (se != NULL) pandora_debug("forgotten stackentry: " << se->id);
  __DELETE(se);
  se = s;
}

StackEntry *PandoraEntry::takeStack(void)
{
  StackEntry *s = se;
  se = NULL;
  return s;
}

void PandoraEntry::setComponent(CompEntry *c)
{
  if (ce != NULL) pandora_debug("forgotten compentry: " << ce->id);
  __DELETE(ce);
  ce = c;
}

CompEntry *PandoraEntry::takeComponent(void)
{
  CompEntry *c = ce;
  ce = NULL;
  return c;
}

void PandoraEntry::setOption(OptionEntry *o)
{
  if (oe != NULL) pandora_debug("forgotten optionentry: " << oe->id);
  __DELETE(oe);
  oe = o;  
}

OptionEntry *PandoraEntry::takeOption(void)
{
  OptionEntry *o = oe;
  oe = NULL;
  return o;
}

