/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PAIR_KEY_H
#define PAIR_KEY_H

#include <libpandora/global.h>
#include <libpandora/dmxkey.h>

class PairKey : public DmxKey {
private:
  long k1, k2;
  key_init(PairKey);

 public:
  inline PairKey(void);
  inline PairKey(long xk1, long xk2);
  virtual ~PairKey(void) { }

  inline void set(long xk1, long xk2);
  inline long hash(void) const;

private:
  bool _equal(const DmxKey *x) const;
};

PairKey::PairKey(void) 
  : k1(0), k2(0) 				
{ 
}

PairKey::PairKey(long xk1, long xk2) 
  : k1(xk1), k2(xk2)  	
{ 
}

void PairKey::set(long xk1, long xk2) 
{ 
  k1 = xk1; 
  k2 = xk2; 
}

long PairKey::hash(void) const 				
{ 
  return (k1 ^ k2); 
}

bool PairKey::_equal(const DmxKey *_x) const
{
  const PairKey *x = (const PairKey *)_x;
  return ((k1 == x->k1) & (k2 == x->k2));
}

#endif /* PAIR_KEY_H */
