/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PAIR_H
#define PAIR_H

template <class _T1, class _T2>
struct Pair {
  _T1 first;
  _T2 second;

  Pair() : first(_T1()), second(_T2()) {}
  Pair(const _T1& a, const _T2& b) : first(a), second(b) {}
  Pair(const Pair<_T1, _T2>& x) : first(x.first), second(x.second) {}
  Pair<_T1, _T2>& operator=(const Pair<_T1, _T2>& x) {
    first = x.first; second = x.second;
    return *this;
  }

  bool operator==(const Pair<_T1, _T2>& x) const { 
    return first == x.first && second == x.second; 
  }
  
  bool operator<(const Pair<_T1, _T2>& x) const { 
    return first < x.first || 
      (!(x.first < first) && second < x.second); 
  }

  bool operator!=(const Pair<_T1, _T2>& x) const { 
    return !operator==(x); 
  }

  operator long (void) const { 
    return (long)((long)first + (long)second); 
  }

};

#endif /* PAIR_H */

