/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PACKET_FACTORY_H
#define PACKET_FACTORY_H

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
}

#include <libpandora/map.h>
#include <libpandora/error.h>

#define MAX_NESTED_PKT	32

class Packet;

class PacketFactory {
private:
  typedef Packet *(*packet_ctor_t)(void);
  const static int max_ctors = 32;
  Map<symbol_id_t, packet_ctor_t> ctors;
  symbol_id_t order[max_ctors];
  int nctors;
  
public:
  PacketFactory(void) : nctors(0)	{ }
  ~PacketFactory(void) 			{ clean(); }

  Packet *createPacket(symbol_id_t ptype);
  bool load(symbol_id_t ptype);
  void clean(void);

private:
  packet_ctor_t getConstructor(symbol_id_t ptype);
};
  
#endif /* PACKET_FACTORY_H */
