/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef OPTION_ENTRY_H
#define OPTION_ENTRY_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/string.h>
	   }

#include <iostream>
#include <libpandora/multivalue.h>
#include <libpandora/text.h>
#include <libpandora/error.h>
  
class OptionEntry {
public:
  text id;
  MultiValue mv;
  text alias;
  bool param;

  inline OptionEntry(void) : param(false) { }
  inline OptionEntry(const text &name) : id(name), param(false) { }
  inline OptionEntry(const OptionEntry &x) ;
  inline OptionEntry &operator=(const OptionEntry &x);
  inline ~OptionEntry(void) { }

  size_t write(char *, size_t maxlen) const;
  size_t read(const char *);
  void   print(ostream *f = &cout) const;

  inline void init(const char *name) { id.init(name);   }
  inline void init(const text &name) { id = name; 	}

  inline void set(int d)		{ mv.set(d); }
  inline void set(bool b) 		{ mv.set(b); }
  inline void set(float f)   		{ mv.set(f); }
  inline void set(const char *s)	{ mv.set(s); }
  inline void set(const MultiValue &m)	{ mv = m;    }

  inline void setAlias(const char *str) { alias.init(str); }
  inline void setParam(void) 		{ param = true; }
  inline bool isParam(void) 		{ return param; }
};

inline void serialize(char *str, size_t &count, 
		 const size_t maxlen, const OptionEntry *oe) 
{
  count += oe->write(str + count, maxlen - count);
}

inline void unserialize(const char *str, size_t &count, OptionEntry *oe)
{
  count += oe->read(str + count);
}

OptionEntry::OptionEntry(const OptionEntry &x) : 
  id(x.id), mv(x.mv), alias(x.alias), param(x.param)
{
}

OptionEntry &OptionEntry::operator=(const OptionEntry &x)
{
  id = x.id; mv = x.mv; alias = x.alias; param = x.param;
  return *this;
}

extern ostream &operator<< (ostream &, const OptionEntry&);

#endif /* OPTION_ENTRY_H */
