/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef NET_SELECT_H
#define NET_SELECT_H

#include <libpandora/global.h>

#include <libpandora/select.h>
#include <libpandora/error.h>

class NetSelect : public Select {
public:
  typedef bool net_func_t(int, void *);

protected:
  sel_new_func_t *infun;
  sel_end_func_t *outfun;

  int 		 listen_fd;
  net_func_t 	 *process;
  void 		 *user_data;

public:
  inline NetSelect(void);
  virtual ~NetSelect(void) 		{ }

  int  fileDesc(void) 			{ return listen_fd; }
  inline bool setup(int fd, net_func_t *f, void *udata, int ms = -1);
};


NetSelect::NetSelect(void) 
  : infun(NULL), outfun(NULL), listen_fd(-1), process(NULL), user_data(NULL)
{
}

bool NetSelect::setup(int fd, net_func_t *f, void *udata, int ms) 
{
  listen_fd = fd;
  process =   f;
  user_data = udata;

  if (listen_fd < 0)  return false;
  if (infun == NULL)  return false;
  if (outfun == NULL) return false;

  if (ms >= 0) setTimeout(ms);
  registerFd(listen_fd, (void *)this, infun, outfun);
  return true;
}

#endif /* NET_SELECT_H */
