/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef MEMSTATS_H
#define MEMSTATS_H

#include <libpandora/global.h>

#ifdef NDEBUG
#define PANDORA_MEMSTATS 0
#else 
#define PANDORA_MEMSTATS 1
#endif

#if PANDORA_MEMSTATS

#define PANDORA_MEMDECL()						\
  public:								\
    static int _allocated;						\
    static int _freed;							\
    static void _report(void)						

#define PANDORA_MEMSTATE(CLASS)						\
    int CLASS::_allocated= 0;						\
    int CLASS::_freed= 0;						\
    void CLASS::_report(void) { 					\
      if (_allocated != _freed) {					\
	pandora_warning("[" << #CLASS << "] allocation mismatch: " 	\
			<< _allocated << "/" << _freed);		\
      }									\
    }

#define PANDORA_CTOR() ++_allocated

#define PANDORA_DTOR() ++_freed

#else /* !PANDORA_COLLECT_STATS */

#define PANDORA_MEMDECL() public: static void _report(void) { }
#define PANDORA_MEMSTATE(CLASS)
#define PANDORA_CTOR()
#define PANDORA_DTOR()

#endif /* !PANDORA_MEMSTATS */

#endif /* MEMSTATS_H */
