/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef INPUT_COMPONENT_H
#define INPUT_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>

#define ERROR_FILENO	-1
#define THREADED_FILENO	-2
#define VOID_FILENO	-3

class InputComponent : public Component {
private:
  bool wsync;
  int  ubkp, cbkp;
  int  user, count;

public:  
  inline InputComponent(void);
  virtual ~InputComponent(void) { }

  virtual bool push(Packet *pkt) ;
  virtual bool add(Packet *);
  virtual bool pull(Packet *);

  void start(void);
  inline void stop(bool force);
  inline void reset(void);
  inline void in_init(void);

  virtual int  init(void) 	= 0;
  virtual bool process(void) 	= 0;
  virtual void finish(void) 	= 0;
  virtual void halt(void) 	{ }

  inline bool isActive(void)	{ return ((user < 0) | (count > 0)); }
};

InputComponent::InputComponent(void) 
  : wsync(false), ubkp(-1), cbkp(-1), user(-1), count(-1) 
{
  registerOption("wsync", &wsync);
  registerOption("count", &user);
  input = true;
}

void InputComponent::stop(bool force)  
{ 
  ubkp = user;
  cbkp = count; 
  user = count = 0; 
  if (force) halt(); 
}

void InputComponent::reset(void) 	
{ 
  user  = ubkp;
  count = (user > 0) ? cbkp : -1; 
}

void InputComponent::in_init(void) 	
{ 
  if ((user > 0) & (count < 0)) count = user; 
}

#endif /* INPUT_COMPONENT_H */

