/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef GEN_MATCH_COMPONENT_H
#define GEN_MATCH_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <libpandora/packet.h>
  
class Packet;

template <class Pkt, class TransPkt>
class GenMatchComponent : public Component {
protected:
  typedef GenMatchComponent<Pkt, TransPkt> GMF;
  Pkt *call, *reply;
  int count;

public:
  GenMatchComponent(void) : call(NULL), reply(NULL), count(0) { }
  virtual ~GenMatchComponent(void) { }

  bool add(Packet* obj);
  void cleanup(void);
};


template <class Pkt, class TransPkt>
bool GenMatchComponent<Pkt, TransPkt>::add(Packet* obj) 
{
  Pkt *genp = static_cast<Pkt *>(obj);
  if (genp->isQuery()) {
    cleanPacket(call);
    call = genp;
  } else {
    cleanPacket(reply);
    reply = genp;
  }

  bool match ((call != NULL) && (reply != NULL));

  if (match) {
    push(new TransPkt(call, reply));
    call = reply = NULL;
  }

  return match;
}

template <class Pkt, class TransPkt>
void GenMatchComponent<Pkt, TransPkt>::cleanup(void)
{
  pandora_assert(call == NULL || reply == NULL);
  if (call != NULL) push(new TransPkt(call));
  if (reply != NULL) push(new TransPkt(reply)); 
  call = reply = NULL;
}

#endif /* GEN_MATCH_COMPONENT_H */
