/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DYN_SYMBOL_H
#define DYN_SYMBOL_H

#include <libpandora/global.h>

#include <libpandora/text.h>
#include <libpandora/error.h>

struct DynLibrary;

struct DynSymbol {
private:
  text symbol;
  DynLibrary *lib;
  int count;
  bool old;

public:
  DynSymbol(const text &name, DynLibrary *l);
  ~DynSymbol(void);

  void *resolve(void);
  bool use(void);
  bool release(void);
  bool flush(void);

  void obsolete(void) 		{ old = true; }
  bool useless(void)  		{ return (old && (count == 0)) ; }

  text getName(void)		{ return symbol; }
  DynLibrary *getLib(void) 	{ return lib; }

  bool inUse(void) 		{ return (count > 0); }

  void print(ostream *f = &cout);
};

extern ostream &operator<< (ostream &, DynSymbol&);

#endif /* DYN_SYMBOL_H */
