/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DYN_LIBRARY_H
#define DYN_LIBRARY_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/unistd.h>
#include <libpandora/conf/string.h>
	   }

#include <libpandora/text.h>
#include <libpandora/error.h>
#include <libpandora/ltdl.h>

class DynBindings;
struct DynSymbol;

struct DynLibrary {
private:
  struct dlrep_t {
    text name;
    lt_dlhandle handle;
    
    dlrep_t(void) : handle(NULL) { }
    ~dlrep_t(void) { pandora_assert(handle == NULL); }
    
    bool open(void);
    bool close(void);
    lt_ptr sym(const char *);
  };

private:
  text		id;
  DynBindings   *bindings;
  dlrep_t 	lib;
  long 		version;
  text 		*dep_names;
  DynLibrary 	**deps;
  int 		ndeps;
  int 		use;
  int 		count;
  bool 		old;
  bool		lock;

public:
  DynLibrary(const text &id, DynBindings *);
  ~DynLibrary(void);

  bool open(void);
  bool close(void);
  void *sym(const char *);

  void obsolete(void)  	 	{  old = true; }
  bool useless(void)   	 	{ return (old && (use == 0) && (count == 0)); }


  void used(void)	 	{ ++use; }
  void unused(void)	 	{ --use; }
  bool inUse(void)	 	{ return (use != 0); }

  bool setVersion(long ver);
  bool setLocalisation(const text &loc);
  bool setDeps(const text *d, int n);

  text getID(void) 	 	{ return id; }
  long getVersion(void) const 	{ return version; }
  text getLocalisation(void) 	{ return lib.name; }
  int  getDeps(text *d, int max_deps);

  void print(ostream *f = &cout);

  friend struct DynSymbol;
};

#endif /* DYN_LIBRARY_H */
