/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DMX_KEY_H
#define DMX_KEY_H

#include <libpandora/global.h>
#include <libpandora/dynloader.h>

#define key_init(cl)						\
  static symbol_id_t key_id;					\
  virtual symbol_id_t getID(void) const { return this->key_id; }

#define key_export(cl)				\
  symbol_id_t cl::key_id = DynLoader::make_id(#cl);

class DmxKey {
public:
  inline DmxKey(void) { }
  virtual ~DmxKey(void) { }

  inline operator long(void) const;
  inline bool operator ==(const DmxKey &x) const;
  inline bool operator !=(const DmxKey &x) const { return !operator==(x); }

  virtual long hash(void) const = 0;

private:
  virtual bool _equal(const DmxKey *) const = 0;
  virtual symbol_id_t getID(void) const = 0;
};

DmxKey::operator long(void) const
{
  return hash();
}

bool DmxKey::operator==(const DmxKey &x) const 
{
  if (getID() != x.getID()) return false;
  return _equal(&x);
}

#endif /* DMX_KEY_H */
