/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

%{
#include <libpandora/global.h>

#include <ctype.h>
#include <libpandora/conf/unistd.h>
#include <stdlib.h>
#include <libpandora/conf/string.h>

#include <libpandora/stackentry.h>

#include "dispgrammar.h"


#define YY_NO_UNPUT
#define YY_DECL int yylex(union yystype *yylval, struct yyltype *yylloc, void *parm)

extern YY_DECL;

#define YY_SKIP_YYWRAP
int yywrap(void) {return -1; }

#define YY_USER_ACTION yylloc->first_line = yylineno;

%}
%option noreject
%option noyymore
%option yylineno

ws 	[ \t\r\n]
comment	(((#|\/\/).*)?\n|\/\*[^\n]*\*\/)
alpha	[a-zA-Z0-9_\-]
modif	[\!\*]
id	({modif}?{alpha}+)
%%

{ws}+				;
\${id}				{yylval->s = xstrdup(yytext+1); return OPTION;}
\@{id}				{yylval->s = xstrdup(yytext+1); return COMP;}
\&{id}				{yylval->s = xstrdup(yytext+1); return MACRO;}
\%{id}				{yylval->s = xstrdup(yytext+1); return STACK;}
\:{id}				{yylval->s = xstrdup(yytext+1); return ALIAS;}
true				{yylval->b = 1; return BOOL;}
false				{yylval->b = 0; return BOOL;}
\-?{ws}*[0-9]+			{yylval->i = atoi((char *)yytext); return NUM;}
\-?{ws}*[0-9]+\.([0-9]*) 	{yylval->f= atof((char *)yytext);return FLOAT;}
[a-zA-Z\._][a-zA-Z0-9\._]*	{yylval->s = xstrdup(yytext); return TOK;}
\"[^\"\n]*\"			{
	yytext[yyleng-1] = '\0';
	yylval->s = xstrdup(yytext+1);
	return LINE;
}
\'[^\'\n]*\'			{
	yytext[yyleng-1] = '\0';
	yylval->s = xstrdup(yytext+1);
	return LINE;
}
{comment}			;
\;				;
.				return yytext[0];
%%
void init_flex_buffer(FILE *f)
{
  yy_delete_buffer(YY_CURRENT_BUFFER);
  if (f != NULL)
    yyin = f;
}        

void init_flex_buffer(const char *str)
{
  yy_delete_buffer(YY_CURRENT_BUFFER);
  if (str != NULL) 
    yy_switch_to_buffer(yy_scan_string(str));
}        
