/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DATALOG_H
#define DATALOG_H

#include <limits.h>

#include <libpandora/global.h>
#include <libpandora/fileutil.h>

class DataLog {
private:
  char 	file[PATH_MAX];
  int 	fd;
  int 	off;
  
public:
  DataLog(void);
  DataLog(const char *dir, const char *base);
  ~DataLog(void);
  
  bool init(const char *, const char *base);
  bool write(const char *, int);
};

#endif /* DATALOG_H */
