/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_SYS_POLL_H
#include <sys/poll.h>
#else
#if HAVE_POLL_H
#include <poll.h>
#else
#ifndef CONF_POLL_H
#define CONF_POLL_H
struct pollfd {
  int fd;
  
  short events;
  short revents;
};


#define POLLIN 001
#define POLLPRI 002
#define POLLOUT 004

#define POLLNORM POLLIN
#define POLLERR 010
#define POLLHUP 020
#define POLLNVAL 040


int poll(struct pollfd *, unsigned int, int);
#endif
#endif
#endif

#ifdef __cplusplus
}
#endif
