/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef COMP_REF_STORE_H
#define COMP_REF_STORE_H

#include <libpandora/global.h>

#include <libpandora/set.h>
#include <libpandora/component.h>  

/** Dispatcher class.
    This class is in charge of instantiating and chaining components.
*/
class CompRefStore {
public:
  typedef Set<Component *> CompSet;
  CompSet *store;

private:
  int size;

public:

  CompRefStore(int siz) : store(NULL), size(siz) { store = new CompSet[siz]; }
  ~CompRefStore(void);

  inline void add(Component *comp);
  inline void remove(Component *comp) ;
};

#define componentsDo(STORE, INDEX, COMP) \
  elementsDo((STORE).store[INDEX], COMP)

void CompRefStore::add(Component *comp) 
{
  pandora_assert(comp != NULL);
  int index = comp->ind;
  pandora_assert(index >= 0 && index < size);
  (store[index]).add(comp);
}

void CompRefStore::remove(Component *comp) 
{
  pandora_assert(comp != NULL);
  int index = comp->ind;
  pandora_assert(index >= 0 && index < size);
  (store[index]).remove(comp);
}

#endif /* COMP_STORE_H */

