/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef COMPLEX_OPTION_H
#define COMPLEX_OPTION_H

#include <libpandora/global.h>

class Component;

#define export_option(cl)					\
  static complex_option *func(void) { return new cl(); }

class complex_option {
private:
  Component *_context;

public:
  complex_option(void) : _context(NULL)	{ }
  virtual ~complex_option(void) 	{ cleanup(); _context = NULL; }

  virtual bool set(const char *)	= 0;
  virtual void *getReference(void)	= 0;
  virtual void cleanup(void) 		{ }

  inline void context(Component *c) 	{ _context = c; }
  inline Component *context(void) 	{ return _context; }
};

#endif /* COMPLEX_OPTION_H */
