/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/compcache.h>
#include <libpandora/compentry.h>
#include <libpandora/component.h>  
#include <libpandora/stackdesc.h>
#include <libpandora/sched_task.h>

#define CACHE_DEBUG	0

int CompCache::default_capacity = 1024;

Component *CompCache::get(int index, const CompEntry *ce) 
{
  CompQueue *cq = &cache[index];
  Component *comp = NULL;
  
  //mx.lock();

  if (cq->isEmpty()) {
    if (!ce->getComponent(&comp)) goto finished;
    comp->ind = index;

#if CACHE_DEBUG
    pandora_debug("creating   comp [" << comp << "] #" << index << "\t(" << cq->size() << ")");
#endif
  } else {
    comp = cq->remove();
    comp->flushed = false;
    comp->demuxed = false;
    comp->branch = 0;
#if CACHE_DEBUG
    pandora_debug("retrieving comp [" << comp << "] #" << index 
		 << "\t(" << cq->size() << ")");
#endif
  }

 finished:  
  //mx.unlock();
  
  return comp;
}

void CompCache::release(Component *comp) 
{
  int index = comp->ind;
  CompQueue *cq = &cache[index];

  //mx.lock();

  if ((!flushAll) 
      && (comp->cacheable)
      && (cq->size() < capacity)) {
    comp->lastTime = 0;
    comp->nextComponent = comp->prevDemux = NULL;
    comp->referrer = NULL;
    pandora_assert(comp->timeout_sched == NULL 
		   || !comp->timeout_sched->isScheduled());
    (void) cq->add(comp);
#if CACHE_DEBUG
    pandora_debug("storing    comp [" << comp << "] #" << index 
		 << "\t(" << cq->size() << ")");
#endif
  } else {
#if CACHE_DEBUG
    pandora_debug("deleting   comp [" << comp << "] #" << index 
		 << "\t(" << cq->size() << ")");
#endif
    __DELETE(comp);
  }

  //mx.unlock();

}

void CompCache::flush(void) 
{
  //pandora_debug("[flush component cache]");
  //mx.lock();
  setFlushAll();
  for (int i = 0; i < size; ++i) {
    CompQueue *cq = &cache[i];
    while(!cq->isEmpty()) {
      Component *comp = cq->remove();
#if CACHE_DEBUG
      pandora_debug("deleting   comp [" << comp << "] #" << i 
		   << "\t(" << cq->size() << ")");
#endif
      __DELETE(comp);
    }
  }

  //mx.unlock();
}
