/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef CLOCK_H
#define CLOCK_H

#include <libpandora/global.h>

#include <libpandora/conf/time.h>
#include <libpandora/thread.h>

class Clock : public Thread {
 private:
  timeval 	current;
  int		res;

 public: 
  Clock(int r = 1000);
  ~Clock(void);

  inline bool gettime(timeval *tv);
  inline bool gettime(time_t *t);
  inline time_t gettime(void);

 protected:
  void main(void);
};

extern Clock *wallclock;

bool Clock::gettime(timeval *tv)
{
  if (tv == NULL) return false;
  if (isRunning()) {
    *tv = current;
  } else {
    if (gettimeofday(tv, NULL) < 0) {
      pandora_pwarning("gettimeofday");
      return false;
    }
  }
  return true;
}

bool Clock::gettime(time_t *t) 
{
  if (t == NULL) return false;
  if (isRunning()) {
    *t = current.tv_sec;
  } else {
    if (time(t) == ((time_t) -1)) {
      pandora_pwarning("time");
      return false;
    }
  }
  return true;
}

time_t Clock::gettime(void)
{
  if (isRunning()) {
    return current.tv_sec;
  } else {
    time_t t;
    if (time(&t) == ((time_t) -1)) {
      pandora_pwarning("time");
      return 0;
    }
    return t;
  }
}

#endif /* CLOCK_H */
