/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef BI_MAP_H
#define BI_MAP_H

#include <libpandora/global.h>

#include <libpandora/map.h>
#include <libpandora/pair.h>

template<class Key1, class Key2, class Val>
class BiMap : public Map< Pair<Key1, Key2> , Val >
{
public:
  typedef Pair<Key1, Key2>	pair;
  typedef Map<pair, Val> 	bimap;

  BiMap() : bimap() {}

public:
  Val	&atOrNil(const Key1 &key1, const Key2 &key2) const {
    return bimap::atOrNil(pair(key1, key2));
  }
  Val 	&at(const Key1 &key1, const Key2 &key2) const {
    return bimap::at(pair(key1, key2));
  }
  bool 	includesKey(const Key1 &key1, const Key2 &key2) const {
    return bimap::includesKey(pair(key1, key2));
  }
  void	atPut(const Key1 &key1, const Key2 &key2, const Val &val) {
    bimap::atPut(pair(key1, key2), val);
  }
    
  Val	removeKey(const Key1 &key1, const Key2 &key2) {
    return bimap::removeKey(pair(key1, key2));
  }
};

#define biKeysDo(MAP, KEY1, KEY2) \
  (KEY1)= (MAP)._undefined.key.first; \
  (KEY2)= (MAP)._undefined.key.second; \
  for(int _1= 0; _1 < ((MAP)._capacity); ++_1) \
    if (((MAP)._array[_1] != (MAP)._undefined) && \
	(((KEY1)= (((((MAP)._array)[_1])).key.first)), \
         ((KEY2)= (((((MAP)._array)[_1])).key.second)), \
	 1))

 
#define biKeysValuesDo(MAP, KEY1, KEY2, VAL) \
  (KEY1)= (MAP)._undefined.key.first; \
  (KEY2)= (MAP)._undefined.key.second; \
  (VAL)= (MAP)._undefined.value; \
  for(int _3= 0; _3 < ((MAP)._capacity); ++_3) \
    if (((MAP)._array[_3] != (MAP)._undefined) && \
	(((KEY1)= (((((MAP)._array)[_3])).key.first)), \
         ((KEY2)= (((((MAP)._array)[_3])).key.second)), \
	 ((VAL)= ((((MAP)._array)[_3]).value)), \
	 1))


#endif /* BI_MAP_H */

