/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <libpandora/conf/string.h>

#ifdef __cplusplus
	   }
#endif

#include <libpandora/anonymize.h>
#include <libpandora/md5.h>

#undef MD5DEBUG
#define DIGEST_LEN	16

void hash_ip(in_addr_t *addr, const text &tkey)
{
  unsigned char digest[DIGEST_LEN];
  unsigned char *tmp;
  size_t keylen = tkey.length();
  size_t addrlen = sizeof(u_int32_t);
  
  if (addr == 0) return;
  
  tmp = (unsigned char *) xmalloc(keylen * sizeof(unsigned char) + addrlen);
  memcpy(tmp, tkey.data(), keylen * sizeof(unsigned char));
  memcpy(tmp + keylen, (unsigned char *)addr, addrlen);

  MDString(tmp, keylen + addrlen, digest);

#ifdef MD5DEBUG
  cout << *addr << ": "; MDPrint(digest);
  cout << endl;
#endif

  memcpy((unsigned char *)addr, digest, addrlen);

  __FREE(tmp);
}


void hash_text(text &t, const text &tkey)
{
  unsigned char digest[DIGEST_LEN];
  unsigned char *tmp;
  size_t keylen = tkey.length();
  size_t textlen = t.length();
  
  if (t.isNull()) return;
  
  tmp = (unsigned char *) xmalloc((keylen+textlen) * sizeof(unsigned char));
  memcpy(tmp, tkey.data(), keylen * sizeof(unsigned char));
  memcpy(tmp + keylen, t.data(), textlen);

  MDString(tmp, keylen + textlen, digest);

#ifdef MD5DEBUG
  cout << *addr << ": "; MDPrint(digest);
  cout << endl;
#endif

  __FREE(tmp);

  t.init((const char *)digest, DIGEST_LEN);
}


void hash_url(text &turl, const text &tkey, int k)
{
  char *tmp, *url, *limit;
  const char *key;
  int i;
  size_t offset, keylen, newlen;
  int digestlen = -1;
  size_t *end;
  unsigned char *digest= NULL;

  url=turl.data();
  key=tkey.data();
  keylen=tkey.length();

  if ((k < 1) || (k > 32)) return;
  if (turl.isNull() || turl.length() < 7) return;
  tmp=strstr((const char *)url,"http://");
  
  if (tmp!= NULL) offset = tmp-url +7;
  else return;
  
  digestlen= k*DIGEST_LEN;
  end= (size_t *)xmalloc(k*sizeof(size_t));
  digest=(unsigned char *)xmalloc((digestlen+1)*sizeof(unsigned char));
  
  
  newlen= keylen+turl.length()-offset;
  
  tmp = url+offset;
  limit = strchr(tmp, '?');
  if (limit == NULL) limit = tmp+newlen+1;

  for (i= 0; i< k; ++i) {
    ++tmp;
    tmp= strchr(tmp,'/');
    if ((tmp != NULL) && (tmp < limit)) end[i]= tmp-url-offset+keylen;
    else break;
  }  
  

  tmp= (char *)xmalloc((1+newlen+ (k-i)*keylen)*sizeof(char));
  memcpy(tmp, key, keylen*sizeof(char));
  memcpy(tmp+keylen, url+offset, (newlen-keylen)*sizeof(char));


  for (/* empty */; i<k; ++i) {
    end[i]=newlen;
    memcpy(tmp+newlen, key, keylen);
    newlen+= keylen;
  }

  end[k-1]= newlen;

  for (i=k-1; i>=0; --i) {
    tmp[end[i]]='\0';
    MDString((unsigned char *)tmp, end[i], digest+i*DIGEST_LEN);
#ifdef MD5DEBUG
    MDPrint(digest+i*DIGEST_LEN);
    printf(": \"%s\"\n", tmp);
#endif
  }
  __FREE(tmp);
  __FREE(end);
  digest[digestlen]='\0';

  turl.take((char *)digest, digestlen);
}

#undef DIGEST_LEN

#if 0
int main(int argc, char **argv)
{
  text turl, tkey;
  int k;

  if (argc<2) return 2;
  turl.data=xstrdup(argv[1]);
  turl.len=strlen(turl.data);
  
  if (argc<3) k= 7;
  else k= atoi(argv[2]);
  
  tkey.data="MySecretKey";
  tkey.len=strlen(tkey.data);
  
  hash_url(turl, tkey, k);
  printf("reulst:\n%s\n", turl.data);
  
  return 0;
}
#endif
