/*
 * $Id: test_enroll-pam_bioapi.c,v 1.2 2006/11/29 20:21:54 nax Exp $
 */

/* Andrew Morgan (morgan@parc.power.net) -- a self contained `blank'
 * application
 *
 * I am not very proud of this code.  It makes use of a possibly ill-
 * defined pamh pointer to call pam_strerror() with.  The reason that
 * I was sloppy with this is historical (pam_strerror, prior to 0.59,
 * did not require a pamh argument) and if this program is used as a
 * model for anything, I should wish that you will take this error into
 * account.
 */

/* Modified by Michael R. Crusoe for pam_bioapi testing */

#include <stdio.h>
#include <stdlib.h>

#include <security/pam_appl.h>
#include <security/pam_misc.h>

/* ------ some local (static) functions ------- */

static void
bail_out (pam_handle_t * pamh, int really, int code, const char *fn)
{
  fprintf (stderr, "==> called %s()\n  got: `%s'\n", fn,
	   pam_strerror (pamh, code));
  if (really && code)
    exit (1);
}

/* ------ some static data objects ------- */

static struct pam_conv conv = {
  misc_conv,
  NULL
};

/* ------- the application itself -------- */

int
main (int argc, char **argv)
{
  pam_handle_t *pamh = NULL;
  char *username = NULL;
  int retcode;

  /* did the user call with a username as an argument ? */

  if (argc > 2)
    {
      fprintf (stderr, "usage: %s [username]\n", argv[0]);
    }
  else if (argc == 2)
    {
      username = argv[1];
    }

  /* initialize the Linux-PAM library */
  retcode = pam_start ("test-pam_bioapi", username, &conv, &pamh);
  bail_out (pamh, 1, retcode, "pam_start");

  /* (re)set the user's "password" (in our case, (re-)enroll them) --- `0' here, could have been PAM_SILENT
   * | PAM_DISALLOW_NULL_AUTHTOK */
  retcode = pam_chauthtok (pamh, 0);
  bail_out (pamh, 0, retcode, "pam_chauthtok");

  /* close the Linux-PAM library */
  retcode = pam_end (pamh, PAM_SUCCESS);
  pamh = NULL;

  bail_out (pamh, 1, retcode, "pam_end");

  exit (0);
}
