/*
 * pam_bioapi.h
 * 
 */
#ifndef PAM_BIOAPI_H
#define PAM_BIOAPI_H

#define PAM_SM_AUTH /* we provide authentication functions */
#define PAM_SM_PASSWORD /* we provide "password" setting functions, in our case enrollment of the biometric */
#include <security/pam_modules.h>
#include <getopt.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#include <pwd.h> /* defines 'struct passwd', and getpwnam(). */
#include <sys/stat.h>
#include <sys/types.h> /* defines 'uid_t', etc.              */

#include <sys/types.h>
#include <sys/wait.h>
#include "earray.h"

#include <libintl.h> /* gnu gettext support */
#define _(String) gettext (String)

//#define DEBUG
#define MAXMSG 2048

typedef struct {
  char *user;
  char *payload;
  char *operation;
  earray_t arrayOfEnrolled;
} out_params_t;

const struct option long_options[] = {
      { "bsp", 1, NULL, 'b' },
      { "backend", 1, NULL, 'B' },
      { "display", 1, NULL, 'd' },
      { "tries", 1, NULL, 't' },
      { "translation", 1, NULL, 'T' },
      { "ask-username", 0, NULL, 'u' },
      { "gui", 0, NULL, 'g' },
      { "payload-to-bir", 0, NULL, 'p' },
      { "show-all-messages", 0, NULL, 's' },
      { "power-save", 0, NULL, 'w' },
      { "debug", 0, NULL, 'D' },
      { NULL, 0, NULL, 0 }
};

sig_atomic_t user_signaled;
sig_atomic_t child_died;

char *listOnlyEnrolledRecords (earray_t);
char *listAllRecords (earray_t, int);
char getActionFromUser (struct pam_conv *);
char *getPayloadFromUser (struct pam_conv *);
static void su_sighandler(int sig);
static void child_sighandler(int sig);
static int child_pid = -1;
//int pam_info (pam_handle_t *pamh, const char *msg, int style, struct pam_response **response);

#define KNOWN_TYPES_COUNT 10
static char *TypeDefinition[KNOWN_TYPES_COUNT] =
{ "right thumb",
  "right index finger",
  "right middle finger",
  "right ring finger",
  "right little finger",
  "left thumb",
  "left index finger",
  "left middle finger",
  "left ring finger", 
  "left little finger" 
};
#endif //PAM_BIOAPI_H
