#ifndef __BIOM_H
#define __BIOM_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <security/pam_appl.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <gnome.h>
#include <glade/glade.h>

/* For testing propose use the local (not installed) glade file */
#define GLADE_FILE PACKAGE_DATA_DIR"/biometrics-manager/glade/fingerprint-manager.glade"
//#define GLADE_FILE "fingerprint-manager.glade"
#define PIPE_SIZE 4096
#define STX 0x2          /* Start of txt */

typedef enum {
        BM_AUTH_MESSAGE_PROMPT_ECHO_ON,
        BM_AUTH_MESSAGE_PROMPT_ECHO_OFF,
        BM_AUTH_MESSAGE_ERROR_MSG,
        BM_AUTH_MESSAGE_TEXT_INFO
} BmMessageStyle;

typedef enum {
        BM_STATE_START,
        BM_STATE_AUTH,
        BM_STATE_AUTH_CANCEL,
        BM_STATE_LIST,
        BM_STATE_MENU,
        BM_STATE_ENROLL_FINGER,
        BM_STATE_ENROLL_CONFIRM,
        BM_STATE_ENROLL_PASSWORD,
        BM_STATE_ENROLL_WAIT,
        BM_STATE_ENROLL_ENROLLING,
        BM_STATE_ENROLL_PRE_LIST,
        BM_STATE_DELETE_FINGER,
        BM_STATE_DELETE_CONFIRM,
        BM_STATE_STOP
} BmState;

typedef struct {
        GladeXML  *xmlgui;
	GtkWidget *mainWindow;
	GtkWidget *authWindow;
	GtkWidget *actionWindow;
	GtkWidget *enrollingWindow;
	GtkWidget *waitWindow;

	GtkWidget *auth_pam_conv_label;
	GtkWidget *auth_prompt_hbox;
	GtkWidget *auth_prompt_label;
	GtkWidget *auth_prompt_entry;
	GtkWidget *auth_ok_button;
	GtkWidget *auth_cancel_button;
	
	GtkWidget *main_user_entry;
	
	GtkWidget *action_password_table;
	GtkWidget *action_password_entry1;
	GtkWidget *action_password_entry2;
	GtkWidget *action_cancel_button;
	GtkWidget *action_exec_button;

	GPtrArray *checkbutton;

	gboolean user_toggled_checkbutton;
	GtkToggleButton *action_over_checkbutton;
	gint pipe_to_pam;
	gint pipe_from_pam;
	gint pam_child_pid;
	
	/* FSA state */
	BmState state;
} gui_t;

typedef gboolean  (* BmMessageFunc) (BmMessageStyle     style,
    				     const char        *msg,
    				     char             **response,
                                     gpointer           data);

struct pam_closure {
        const char       *username;
        BmMessageFunc     cb_func;
        gpointer          cb_data;
};


gboolean
bm_pam_enroll (const char       *username,
                     BmMessageFunc func,
                     gpointer          data);

gui_t * BmBuildGui ();
gboolean BmMessageHandler (BmMessageStyle  style,
                        const char        *msg,                                      
                        char             **response,
                        gpointer           data);

void main_checkbutton_clicked (GtkWidget *widget, gpointer data);

void bm_fdprintf (int fd, const gchar *format, ...);

gboolean askUserYesNoDialog (GtkWidget *parent, gchar *question);
void show_error_dialog (gchar *);
#endif
