/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * biom-fsa.c
 * Copyright (C) Josef Hajas 2006 <josef@hajas.net>
 * 
 * biom-gui.c is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * main.c is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.c.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include "biom.h"

BmState fsaStart (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state;

	switch (style) {
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_ON:
	    *response = "y";
	    state = BM_STATE_AUTH;
	    break;
	  default:
	    g_warning ("Unexpected input from PAM! "
		"Please make sure PAM_BIOAPI is only one module in /etc/pam.d/%s",
		PAM_SERVICE_NAME);
	    _exit (2);
	}

  	return state;
}

BmState fsaAuth (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_AUTH;

	switch (style) {
	  case BM_AUTH_MESSAGE_TEXT_INFO:
	    gtk_widget_hide (gui->auth_prompt_hbox);
	    gtk_widget_set_sensitive (gui->auth_ok_button,FALSE);
	    gtk_label_set_text ((GtkLabel *) gui->auth_pam_conv_label, msg);
	    gtk_widget_show (gui->authWindow);
	    *response = "";
	    break;
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_OFF:
	    gtk_widget_show (gui->auth_prompt_hbox);
	    gtk_widget_set_sensitive (gui->auth_ok_button,TRUE);
	    gtk_widget_set_sensitive (gui->auth_prompt_hbox,TRUE);
	    gtk_entry_set_visibility (GTK_ENTRY (gui->auth_prompt_entry),FALSE);

	    /* set default button and lets ENTER in entry run OK */
	    GTK_WIDGET_SET_FLAGS (gui->auth_ok_button, GTK_CAN_DEFAULT);
	    gtk_widget_grab_default (gui->auth_ok_button);
	    gtk_widget_grab_focus (gui->auth_prompt_entry);
	    gtk_entry_set_activates_default (GTK_ENTRY (gui->auth_prompt_entry),TRUE);
	    gtk_label_set_text (GTK_LABEL (gui->auth_prompt_label), _(msg));
	    gtk_label_set_text ((GtkLabel *) gui->auth_pam_conv_label, " ");
	    gtk_widget_show (gui->authWindow);
	    break;
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_ON:
	    state = BM_STATE_LIST;
	    *response = "l";
	    break;
	  default:
	    g_warning ("Unexpected input from PAM! "
		"Please make sure PAM_BIOAPI is only one module in /etc/pam.d/%s",
		PAM_SERVICE_NAME);
	    _exit (2);
	}

  	return state;
}

BmState fsaAuthCancel (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{

	  //g_assert (style == BM_AUTH_MESSAGE_ERROR_MSG);
	  *response = "";

	  return BM_STATE_AUTH;
}


BmState fsaList (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_LIST;
	gchar** lines;
	gint i, type;

	switch (style) {
	  case BM_AUTH_MESSAGE_TEXT_INFO:
	    lines = g_strsplit (msg, "\n", 0);
	    i = 0;
	    type = -1;

	    gui->user_toggled_checkbutton = FALSE;
	    for (i=0; i < gui->checkbutton->len; i++) {
	        gtk_toggle_button_set_active (
		   GTK_TOGGLE_BUTTON ( g_ptr_array_index (gui->checkbutton,i)),
		   FALSE);
	    }
	    i=0;
	    while (1) {
	       gchar** tokens = g_strsplit (lines[i], " ", 1);
	       if (! tokens[0]) {
	         g_strfreev (tokens);
		 break;
	       }
               type = atoi (tokens[0]);
	       g_strfreev (tokens);
	       if ((0 < type) && (type < gui->checkbutton->len)) {
		   gtk_toggle_button_set_active (
		       GTK_TOGGLE_BUTTON ( g_ptr_array_index (gui->checkbutton,type-1)), 
		       TRUE);
	       } else {
		 break;
	       }
	       i++;
	    }
	    g_strfreev (lines);

	    gui->user_toggled_checkbutton = TRUE;

	    gtk_widget_set_sensitive (gui->mainWindow, TRUE);
	    gtk_widget_show (gui->mainWindow);
	    gtk_widget_hide (gui->authWindow);
	    *response = "";
	    break;
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_ON:
	    state = BM_STATE_MENU;
	    gtk_widget_set_sensitive (gui->mainWindow, TRUE);
	    gtk_widget_hide (gui->waitWindow);
	    if (gui->action_over_checkbutton) {
		gtk_toggle_button_set_inconsistent (
		    gui->action_over_checkbutton, 
		    FALSE);
	    }
	    break;
	  default:
	    g_warning ("Unexpected input from PAM!");
	    _exit (2);
	}

  	return state;
}

BmState fsaMenu (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_MENU;

  	return state;
}

gint finger (GtkToggleButton *choosen_checkbutton) 
{
       gint fingerID = -1;
       const gchar *name = gtk_widget_get_name (GTK_WIDGET (choosen_checkbutton));
       fingerID = atoi (name + (strlen ("checkbutton")));

       return fingerID;
}

BmState fsaEnrollFinger (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_ENROLL_ENROLLING;
	*response = g_strdup_printf ("%d", finger (gui->action_over_checkbutton));
	if (! gtk_toggle_button_get_active (
	      GTK_TOGGLE_BUTTON (gui->action_over_checkbutton))) {
	    state = BM_STATE_ENROLL_CONFIRM;
	    gui->user_toggled_checkbutton = FALSE;
	    gtk_toggle_button_set_active (
	      GTK_TOGGLE_BUTTON (gui->action_over_checkbutton), TRUE);
	    gui->user_toggled_checkbutton = TRUE;
	}

  	return state;
}

BmState fsaEnrollConfirm (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_ENROLL_PASSWORD;
	*response = "y";

  	return state;
}

BmState fsaEnrollPassword (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_ENROLL_WAIT;

	/*if (gtk_toggle_button_get_active (
	      GTK_TOGGLE_BUTTON (gui->action_password_checkbutton) )) {
	   *response = (char *) gtk_entry_get_text (
	       GTK_ENTRY (gui->action_password_entry1));
	} else {*/
	   *response = "";
	//}
	//gtk_widget_set_sensitive (gui->actionWindow, FALSE);
	g_warning ("State: Enroll_Password");

  	return state;
}

gboolean
is_YN_question (const char *question) {
  int len = strlen (question);
  return (   (question [len-3] == 'n') || (question [len-3] == 'N') 
          || (question [len-3] == 'Y') || (question [len-3] == 'y'))
      && (question [len-2] == ']') 
      && (question [len-1] == ' ');
}

BmState fsaEnrollEnrolling (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_ENROLL_ENROLLING;

	switch (style) {
	  case BM_AUTH_MESSAGE_TEXT_INFO:
	    gtk_widget_show (gui->enrollingWindow);
	    gtk_message_dialog_set_markup (GTK_MESSAGE_DIALOG (gui->enrollingWindow),
	     	msg);
	    *response = "";
	    break;
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_OFF:
  	    state = BM_STATE_ENROLL_WAIT;
	    if (askUserYesNoDialog (gui->actionWindow,
		  _("Would you like to save password with just enrolled fingerprint? [n/y] "))) {
	       gtk_widget_show (gui->actionWindow);
	    } else {
	       *response = "";
	       gtk_widget_hide (gui->enrollingWindow);
	       gtk_widget_show (gui->waitWindow);
	       //gtk_widget_set_sensitive (gui->mainWindow, TRUE);
	    }
	    break;
	  case BM_AUTH_MESSAGE_ERROR_MSG:
	    gtk_toggle_button_set_active (
		gui->action_over_checkbutton, 
		FALSE);
	    gtk_widget_set_sensitive (gui->mainWindow, TRUE);
	    gtk_widget_hide (gui->enrollingWindow);
	    gtk_widget_hide (gui->actionWindow);
	    gtk_widget_set_sensitive (gui->actionWindow, TRUE);
	    gtk_toggle_button_set_inconsistent (
		gui->action_over_checkbutton, 
		FALSE);
	    *response = "";
	    break;
	  default:
	    g_warning ("Unexpected input from PAM! "
		"Please make sure PAM_BIOAPI is only one module in /etc/pam.d/%s",
		PAM_SERVICE_NAME);
	    _exit (2);
	}

  	return state;
}

BmState fsaEnrollWait (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_MENU;

	switch (style) {
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_ON:
	    state = BM_STATE_MENU;
	    state = BM_STATE_MENU;
	    if (is_YN_question (msg)) {
		state = BM_STATE_ENROLL_PRE_LIST;
	        if (askUserYesNoDialog (gui->waitWindow, (gchar *) msg)) {
	           *response = "y";
		} else {
	    	   *response = "n";
		}
	    } else {
		gtk_widget_set_sensitive (gui->mainWindow, TRUE);
		gtk_widget_hide (gui->waitWindow);
		gtk_widget_set_sensitive (gui->actionWindow, TRUE);
		gtk_toggle_button_set_inconsistent (
		    gui->action_over_checkbutton, 
		    FALSE);
	    }
	    break;
	  default:
	    g_warning ("Unexpected input from PAM! "
		"Please make sure PAM_BIOAPI is only one module in /etc/pam.d/%s",
		PAM_SERVICE_NAME);
	    _exit (2);
	}

  	return state;
}



BmState fsaEnrollPreList (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_ENROLL_PRE_LIST;
	//GtkWidget *dialog;

	switch (style) {
	  case BM_AUTH_MESSAGE_TEXT_INFO:
	    /*dialog = gtk_message_dialog_new (GTK_WINDOW (gui->actionWindow),
					      GTK_DIALOG_MODAL,
					      GTK_MESSAGE_WARNING,
					      GTK_BUTTONS_OK, 
					      (gchar *) msg);
	    gtk_dialog_run (GTK_DIALOG (dialog));
	    gtk_widget_destroy (dialog);*/
	    *response = "";

	    break;
	  case BM_AUTH_MESSAGE_PROMPT_ECHO_ON:
	    state = BM_STATE_LIST;
	    *response = "l";
	    break;
	  default:
	    g_warning ("Unexpected input from PAM! "
		"Please make sure PAM_BIOAPI is only one module in /etc/pam.d/%s",
		PAM_SERVICE_NAME);
	    _exit (2);
	}

  	return state;
}

BmState fsaDeleteFinger (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_DELETE_CONFIRM;
	*response = g_strdup_printf ("%d", finger (gui->action_over_checkbutton));

  	return state;
}

BmState fsaDeleteConfirm (BmMessageStyle     style,
                        const char  *msg,
                        char       **response,
                        gui_t        *gui)
{
  	BmState state = BM_STATE_MENU;
	if (askUserYesNoDialog (gui->mainWindow, (gchar *) msg)) {
	  *response = "Y";
	} else {
	  *response = "N";
	  gui->user_toggled_checkbutton = FALSE;
	  gtk_toggle_button_set_active (
	      gui->action_over_checkbutton, 
	      TRUE);
	  gui->user_toggled_checkbutton = TRUE;
	}

	gtk_toggle_button_set_inconsistent (
	    gui->action_over_checkbutton, 
	    FALSE);
	gtk_widget_set_sensitive (gui->mainWindow, TRUE);

  	return state;
}


gboolean BmMessageHandler (BmMessageStyle     style,
                        const char        *msg,                                      
                        char       **response,
                        gpointer           data)
{
  	gui_t *gui = (gui_t *) data;
	*response = NULL;

	//g_message ("msg: %s", msg); //DEBUGING

	if ((style == BM_AUTH_MESSAGE_ERROR_MSG) &&
	   (gui->state != BM_STATE_ENROLL_ENROLLING) &&
	   (gui->state != BM_STATE_AUTH_CANCEL)) {
	    show_error_dialog ((gchar *) msg);
	    *response = "";
	    if ((gui->state == BM_STATE_AUTH) &&
		(! GTK_WIDGET_VISIBLE (gui->authWindow))){
	        if (gui->pam_child_pid != -1) {
	           kill (gui->pam_child_pid, SIGINT);
	           exit(2);
		}
	    }
        } else {
	    switch (gui->state) {
	      case BM_STATE_START:
		gui->state = fsaStart (style, msg, response, gui);
		break;
	      case BM_STATE_AUTH:
		gui->state = fsaAuth (style, msg, response, gui);
		break; 
	      case BM_STATE_AUTH_CANCEL:
		gui->state = fsaAuthCancel (style, msg, response, gui);
		break; 
	      case BM_STATE_LIST:
		gui->state = fsaList (style, msg, response, gui);
		break;
	      case BM_STATE_MENU:
		gui->state = fsaMenu (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_FINGER:
		gui->state = fsaEnrollFinger (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_CONFIRM:
		gui->state = fsaEnrollConfirm (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_PASSWORD:
		gui->state = fsaEnrollPassword (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_ENROLLING:
		gui->state = fsaEnrollEnrolling (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_WAIT:
		gui->state = fsaEnrollWait (style, msg, response, gui);
		break;
	      case BM_STATE_ENROLL_PRE_LIST:
		gui->state = fsaEnrollPreList (style, msg, response, gui);
		break;
	      case BM_STATE_DELETE_FINGER:
		gui->state = fsaDeleteFinger (style, msg, response, gui);
		break;
	      case BM_STATE_DELETE_CONFIRM:
		gui->state = fsaDeleteConfirm (style, msg, response, gui);
		break;
	      default:
		g_warning ("Unknown state! ");
	    }
	}

	//g_message ("response: [%s]", *response); //DEBUGIGNG

	return TRUE;
}

