/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * biom-gui.c
 * Copyright (C) Josef Hajas 2006 <josef@hajas.net>
 * 
 * biom-gui.c is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * main.c is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.c.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include "biom.h"

/* callbacks */
void
auth_ok_button_clicked (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
  	const gchar *response = gtk_entry_get_text (GTK_ENTRY (gui->auth_prompt_entry));
	
	GTK_WIDGET_SET_FLAGS (gui->auth_cancel_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (gui->auth_cancel_button);
	gtk_widget_set_sensitive (gui->auth_ok_button,FALSE);
	gtk_widget_set_sensitive (gui->auth_prompt_hbox,FALSE);
	gtk_label_set_text (GTK_LABEL (gui->auth_pam_conv_label), 
	    _("Please wait ..."));
	gtk_widget_show (gui->authWindow);

	bm_fdprintf (gui->pipe_to_pam, "%c%s\n", STX, response);

}

void
app_close (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;

	if (gui->pam_child_pid != -1) {
	    bm_fdprintf (gui->pipe_to_pam, "%cx\n", STX);
	}

	g_ptr_array_free (gui->checkbutton, TRUE);
	free (gui);
	gtk_main_quit();
}

void
auth_close (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;

	if (gui->pam_child_pid != -1) {
	    kill (gui->pam_child_pid, SIGINT);
	}
	// TODO: waitpid

	free (gui);
	gtk_main_quit();
}

void
auth_cancel (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;

	if (gui->pam_child_pid != -1) {
	    //gui->state = BM_STATE_AUTH_CANCEL;
	    kill (gui->pam_child_pid, SIGINT);
	}
}

void
main_user_button_apply (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
	const gchar *user = NULL;
	int ret = 0, rc = 0;

	if (gui->pam_child_pid != -1) {
	    bm_fdprintf (gui->pipe_to_pam, "%cx\n", STX);
	    //TODO: unregister channel!!!
	    rc = waitpid(gui->pam_child_pid, &ret, 0);
	    //close (gui->pipe_to_pam);
	    //close (gui->pipe_from_pam);
	}

	gtk_widget_set_sensitive (gui->mainWindow, FALSE);
	gui->state = BM_STATE_START;
	user = gtk_entry_get_text (GTK_ENTRY (gui->main_user_entry));
	bm_pam_enroll (user, BmMessageHandler, gui);
}

void
action_close (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
	
	gtk_widget_set_sensitive (gui->mainWindow, TRUE);
	gtk_widget_hide (gui->actionWindow);
	gtk_toggle_button_set_inconsistent (
	    gui->action_over_checkbutton, 
	    FALSE);
	gui->user_toggled_checkbutton = FALSE;
	gtk_toggle_button_set_active (
	    gui->action_over_checkbutton, 
	    ! gtk_toggle_button_get_active (gui->action_over_checkbutton));
	gui->user_toggled_checkbutton = TRUE;
}

gboolean
password_entries_match (GtkWidget *entry1, GtkWidget *entry2) {
	const gchar *password1, *password2;
	gboolean ret = FALSE;

	password1 = gtk_entry_get_text (GTK_ENTRY (entry1));
	password2 = gtk_entry_get_text (GTK_ENTRY (entry2));

	if (! strcmp ((char *) password1, (char *) password2)) {
	    ret = TRUE;
	}
	return ret;

}

void
action_cancel_button_clicked (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;

        bm_fdprintf (gui->pipe_to_pam,"%c\n",STX);
	gtk_widget_hide (gui->actionWindow);
	gtk_widget_show (gui->waitWindow);

}

void
action_exec_button_clicked (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
	if (password_entries_match (gui->action_password_entry1, 
				    gui->action_password_entry2)) {
             bm_fdprintf (gui->pipe_to_pam,"%c%s\n",STX,
		 gtk_entry_get_text (GTK_ENTRY (gui->action_password_entry1)));
	     gtk_widget_hide (gui->actionWindow);
	     gtk_widget_show (gui->waitWindow);
	} else {
	     GtkWidget *dialog;
	     dialog = gtk_message_dialog_new (GTK_WINDOW (gui->actionWindow),
					      GTK_DIALOG_MODAL,
					      GTK_MESSAGE_WARNING,
					      GTK_BUTTONS_OK, 
					      (gchar *) _("Passwords do not match!"));
	     gtk_message_dialog_format_secondary_text (GTK_MESSAGE_DIALOG (dialog),
	       (gchar *) _("Please fill in password again."));
	     gtk_dialog_run (GTK_DIALOG (dialog));
	     gtk_widget_destroy (dialog);
	}

}

void
main_checkbutton_clicked (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
	if (gui->user_toggled_checkbutton) {
	     gui->action_over_checkbutton = GTK_TOGGLE_BUTTON (widget);
	     gtk_toggle_button_set_inconsistent (GTK_TOGGLE_BUTTON (widget), TRUE);
	     /* some cleanup in password */
	     gtk_entry_set_text (GTK_ENTRY (gui->action_password_entry1), "");
	     gtk_entry_set_text (GTK_ENTRY (gui->action_password_entry2), "");
	     //gtk_widget_show (gui->actionWindow);

	     if (gtk_toggle_button_get_active (
		      GTK_TOGGLE_BUTTON (widget))) {
		 /* enroll */
		 gui->state = BM_STATE_ENROLL_FINGER;
		 bm_fdprintf (gui->pipe_to_pam,"%ce\n",STX);
	     } else {
		 /* delete */
		 gui->state = BM_STATE_DELETE_FINGER;
		 bm_fdprintf (gui->pipe_to_pam,"%cd\n",STX);
	     }

	     gtk_widget_set_sensitive (gui->mainWindow, FALSE);
	}
}

void
enrolling_cancel (GtkWidget *widget, gpointer data) {
  	gui_t *gui = data;
	
	gtk_widget_hide (gui->enrollingWindow);
	if (gui->pam_child_pid != -1) {
	    kill (gui->pam_child_pid, SIGINT);
	}
}

gboolean
askUserYesNoDialog (GtkWidget *parent, gchar *question) {
	 GtkWidget *dialog;
	 gint len = strlen (question);
	 gchar *question_for_display = question = g_strndup (question, len-7);
	 GtkResponseType result = GTK_RESPONSE_NO;
	 dialog = gtk_message_dialog_new (GTK_WINDOW (parent),
					  GTK_DIALOG_MODAL |
					  GTK_DIALOG_DESTROY_WITH_PARENT,
					  GTK_MESSAGE_QUESTION,
					  GTK_BUTTONS_YES_NO, 
					  question_for_display);
	 result = gtk_dialog_run (GTK_DIALOG (dialog));
	 gtk_widget_destroy (dialog);
	 g_free (question_for_display);
	 if (result == GTK_RESPONSE_YES) {
	   return TRUE;
	 }
	 return FALSE;
}

void
show_error_dialog (gchar *errormsg) {
	 GtkWidget *dialog;
	 dialog = gtk_message_dialog_new (NULL,
					  GTK_DIALOG_MODAL,
					  GTK_MESSAGE_ERROR,
					  GTK_BUTTONS_OK, 
					  errormsg);
	 gtk_dialog_run (GTK_DIALOG (dialog));
	 gtk_widget_destroy (dialog);
}

/* creating windows and filling gui structure */
GtkWidget*
create_main_window (gui_t *gui)
{
	GtkWidget *widget, *mainWindow;
	gint i = 0;

	//GtkImage *image1;
	//image1 = (GtkImage *) glade_xml_get_widget (gui->xmlgui, "main_image_hands");
	//gtk_image_set_from_file (image1,"hands.png");
	
	if (geteuid() == 0) {
	    // runing as root
	    widget = glade_xml_get_widget (gui->xmlgui, "main_user_hbox");
	    gtk_widget_show (widget);
	    gui->main_user_entry = glade_xml_get_widget (gui->xmlgui, 
		"main_user_entry");
	    gtk_entry_set_text (GTK_ENTRY (gui->main_user_entry), g_get_user_name());
	    widget = glade_xml_get_widget (gui->xmlgui, "main_user_button_apply");
	    GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
	    gtk_widget_grab_default (widget);
	    gtk_widget_grab_focus (gui->main_user_entry);
	    gtk_entry_set_activates_default (GTK_ENTRY (gui->main_user_entry),TRUE);
	    g_signal_connect (G_OBJECT (widget), "clicked",
                        G_CALLBACK (main_user_button_apply), gui);
	}

	widget = glade_xml_get_widget (gui->xmlgui, "main_close_button");
	g_signal_connect (G_OBJECT (widget), "clicked",
                        G_CALLBACK (app_close), gui);
        GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (widget);

	mainWindow = glade_xml_get_widget (gui->xmlgui, "dialog_fingerprint-manager");
	g_signal_connect (G_OBJECT (mainWindow), "destroy",
                        G_CALLBACK (app_close), gui);

	gui->checkbutton = g_ptr_array_new ();
	while (widget != NULL) {
	  i++;
	  gchar *name = g_strdup_printf ("checkbutton%d", i);
	  widget = glade_xml_get_widget (gui->xmlgui, name);
	  if (widget) {
	  	g_ptr_array_add (gui->checkbutton, (gpointer) widget);
	        g_signal_connect (G_OBJECT (widget), 
		   "clicked", G_CALLBACK (main_checkbutton_clicked), gui);
	  }
	}

	return mainWindow;
}

GtkWidget*
create_auth_window (gui_t *gui)
{
	GtkWidget *authWindow;

	gui->auth_pam_conv_label = 
	  glade_xml_get_widget (gui->xmlgui, "auth_pam_conv_label");
	gui->auth_prompt_hbox = 
	  glade_xml_get_widget (gui->xmlgui, "auth_prompt_hbox");
	gui->auth_prompt_label = 
	  glade_xml_get_widget (gui->xmlgui, "auth_prompt_label");
	gui->auth_prompt_entry = 
	  glade_xml_get_widget (gui->xmlgui, "auth_prompt_entry");

	gui->auth_ok_button = 
	  glade_xml_get_widget (gui->xmlgui, "auth_ok_button");
	g_signal_connect (G_OBJECT (gui->auth_ok_button), "clicked",
                        G_CALLBACK (auth_ok_button_clicked), gui);

	gui->auth_cancel_button = 
	  glade_xml_get_widget (gui->xmlgui, "auth_cancel_button");
	g_signal_connect (G_OBJECT (gui->auth_cancel_button), "clicked",
                        G_CALLBACK (auth_cancel), gui);

	authWindow = glade_xml_get_widget (gui->xmlgui, "auth_dialog");
	g_signal_connect (G_OBJECT (authWindow), "destroy",
                        G_CALLBACK (auth_close), gui);

	return authWindow;
}

GtkWidget*
create_action_window (gui_t *gui)
{
	GtkWidget *actionWindow;

	gui->action_password_table = 
	  glade_xml_get_widget (gui->xmlgui, "action_password_table");
	gui->action_password_entry1 = 
	  glade_xml_get_widget (gui->xmlgui, "action_password_entry1");
	gui->action_password_entry2 = 
	  glade_xml_get_widget (gui->xmlgui, "action_password_entry2");

	gui->action_exec_button = 
	  glade_xml_get_widget (gui->xmlgui, "action_execute_button");
	g_signal_connect (G_OBJECT (gui->action_exec_button), "clicked",
                        G_CALLBACK (action_exec_button_clicked), gui);

	gui->action_cancel_button = 
	  glade_xml_get_widget (gui->xmlgui, "action_cancel_button");
	g_signal_connect (G_OBJECT (gui->action_cancel_button), "clicked",
                        G_CALLBACK (action_cancel_button_clicked), gui);

	// always on top
	actionWindow = glade_xml_get_widget (gui->xmlgui, "action_dialog");
	gtk_window_set_transient_for (GTK_WINDOW (actionWindow), 
	    GTK_WINDOW (gui->mainWindow));
	/*g_signal_connect (G_OBJECT (actionWindow), "destroy",
                        G_CALLBACK (action_destroy), gui);*/

	return actionWindow;
}

GtkWidget*
create_enrolling_window (gui_t *gui)
{
	GtkWidget *enrollingWindow;

	enrollingWindow = glade_xml_get_widget (gui->xmlgui, "enrolling_messagedialog");
	gtk_window_set_transient_for (GTK_WINDOW (enrollingWindow), 
	    GTK_WINDOW (gui->actionWindow));
	g_signal_connect (G_OBJECT (enrollingWindow), "destroy",
                        G_CALLBACK (enrolling_cancel), gui);

	return enrollingWindow;
}

GtkWidget*
create_wait_window (gui_t *gui)
{
	GtkWidget *waitWindow;

	waitWindow = glade_xml_get_widget (gui->xmlgui, "wait_window");
	gtk_window_set_transient_for (GTK_WINDOW (waitWindow), 
	    GTK_WINDOW (gui->actionWindow));

	return waitWindow;
}



gui_t *
BmBuildGui ()
{
	gui_t *gui;
        
	gui = malloc (sizeof (gui_t));
	if (! gui)
	  return NULL;
	gui->pipe_from_pam = -1;
	gui->pipe_to_pam = -1;
	gui->pam_child_pid = -1;
	gui->action_over_checkbutton = NULL;

	gui->xmlgui = glade_xml_new (GLADE_FILE, NULL, NULL);

	gui->authWindow = create_auth_window (gui);
	gui->mainWindow = create_main_window (gui);
	gui->actionWindow = create_action_window (gui);
	gui->enrollingWindow = create_enrolling_window (gui);
	gui->waitWindow = create_wait_window (gui);

	return gui;
}
