#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

##  This file is part of orm, The Object Relational Membrane Version 2.
##
##  Copyright 2002-2006 by Diedrich Vorberg <diedrich@tux4web.de>
##
##  All Rights Reserved
##
##  For more Information on orm see the README file.
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##
##  I have added a copy of the GPL in the file gpl.txt.

#
# $Log: __init__.py,v $
# Revision 1.1  2006/04/28 09:56:41  diedrich
# Initial commit
#
#

"""
Someday there will be user interface 'glue' in this module. Now there
is just a lot of undocumented code that makes no sense.
"""


_widget_index = 1

class widget_spec:
    """
    Objects of this class are placeholders for objects instantiated from
    the classes in the orm2.ui.wrappers.* modules.
    """
    def __init__(self, module, cls, **kw):
        """
        @param module: A regular Python string, name of one of the modules
            in orm2.ui.wrappers
        @param cls: A class name from the module refered to by `module'

        The constructos takes arbitrary keyword arguments that will be passed
        to the constructor of module.cls by __call__() if not overwritten by
        __call__'s key word arguments, see below.

        This module defines a variable called _widget_index that will be
        copied to each widget instance and then incremented. This is ment to
        preserve the order in which widgets (and datatypes) occur in the
        dbclass definition.
        """
        global _widget_index
        
        self.module = module
        self.cls = cls
        self.kw = kw
        
        self.__index__ = _widget_index
        _widget_index += 1

    def __init_datatype__(self, datatype):
        """
        This is called by the datatype we are a widget for to introduce itself.
        """
        self.datatype = datatype

    def __cmp__(self, other):
        """
        This makes sort() on sequences of widget objects use the _widget_index
        for sorting
        """
        return cmp(self._widget_index, other._widget_index)

    def dbclass(self):
        """
        Helperfunction that returns our datatype's dbclass, if set.
        """
        return self.datatype.dbclass

    def __call__(self, **kw):
        """
        Instanciate an object of the wrapper class pointed to by
        self.module and self.cls. Pass the default keyword arguments
        from our own constructor after they have been updated by our
        keyword arguments.

        @returns: An object of module.cls
        """
        # import the appropriate widget module
        module = __import__("orm2.ui.wrappers.%s" % self.module, globals(),
                            {}, ["orm2", "ui", "wrappers"])
        cls = module.__dict__[self.cls]
        mykw = self.kw.copy()
        mykw.update(kw)

        return cls(self.datatype, **mykw)


class widget_wrapper:
    """
    'The mother of all widget wrappers.' I wonder who's their
    dad... anyway, it doesn't have much of a purpose than have a
    common base class for all of them.
    """
    def __init__(self, datatype):
        """
        @param datatype: The datatype this widget is supposed to
        reprsent.
        """
        self.datatype = datatype
        

# Local variables:
# mode: python
# ispell-local-dictionary: "english"
# End:

