import QtQuick 2.0                           // Standardkomponent ein alltid må ha
import QtQuick.Controls 1.0 as QtControls    // For bruk av ScrollView
import QtQuick.Layouts 1.1                   // For plassering av alle elementa
import QtWebKit 3.0                          // For HTML-vising
import org.kde.plasma.core 2.0 as PlasmaCore // For datamotoren som kallar «ordbanken»
import QtWebKit.experimental 1.0             // For å unngå forminska tekst i HTML-ruta
import org.kde.plasma.components 2.0 as PlasmaComponents // KDE-alternativ til standardkomponentar

// Hovudvindauge
Item {
    id: rot
    width: 600 // Brei som standard, for å få plass til alle kontrollane
    height: 400
    clip: true // For å unngå at tekst til avkryssingsboksar går utanfor vindauget
    
    // Grupper etter ord og paradigme som standard
    property var arg_ord: "--grupper-ord"
    property var arg_paradigme: "--grupper-paradigme"
    
    // Køyring av programfila «ordbanken»
    PlasmaCore.DataSource {
        engine: "executable"
        connectedSources: ["ordbanken --html " + arg_ord + " " +
                           arg_paradigme + " -- '" + 
                           ord.text.replace("'", "’").replace(" ", "' '") + "'"]
        interval: 0 // Oppdater (berre) når «ord.text» vert endra
        
        // Når me får nye søkeresultat (som skjer kvar gong søkefeltet
        // vert oppdatert, oppdater HTML-visinga (eller gøym ho heilt
        // dersom søkefeltet er tomt)
        onNewData:{
            if(ord.text != "") {
                resultat.loadHtml(data.stdout)
                resultatrad.visible = true
            }
            else {
                // Merk at me gøymer HTML-ruta *før* me tømmer ho,
                // då det gjev eit meir responsivt brukargrensesnitt
                resultatrad.visible = false
                resultat.loadHtml("")
            }
        }
    }
    
    // Vis kontrollar og resultat nedover
    ColumnLayout {
        id: root
        width: parent.width
        anchors.left: parent.left
        anchors.right: parent.right
        
        // Først ei rad med søke- og avkryssingsboksar
        RowLayout {
            id: knapprad
            spacing: 2*units.smallSpacing
            
            // Søkefelet
            PlasmaComponents.TextField {
                id: ord
                placeholderText: "Skriv inn ordet du vil sjå bøyinga til …"
                clearButtonShown: true   // Vis knapp for å tømma feltet
                Layout.minimumWidth: 200 // Søkefeltet må alltid vera synleg
                Layout.fillWidth: true

            }
            
            // Avkryssingsboks for ordgruppering
            PlasmaComponents.CheckBox {
                id: grupper_ord
                checked: true
                clip: true
                text: "Grupper etter ord"
                
                // Endra innstillingane når brukaren krysser på/av
                onClicked:{
                    if(grupper_ord.checked)
                        arg_ord="--grupper-ord"
                        else
                            arg_ord="--ikkje-grupper-ord"
                }
            }
            
            // Avkryssingsboks for paradigmegruppering
            PlasmaComponents.CheckBox {
                id: grupper_paradigme
                checked: true
                clip: true
                text: "Grupper etter bøyingsparadigme"
                
                // Endra innstillingane når brukaren krysser på/av
                onClicked:{
                    if(grupper_paradigme.checked)
                        arg_paradigme="--grupper-paradigme"
                        else
                            arg_paradigme="--ikkje-grupper-paradigme"
                }
            }
        }
        
        // Rad for vising av søkeresultata
        Row {
            id: resultatrad
            visible: false // Gøym rada før brukaren har søkt

            // Legg til rullefelt om nødvendig
            QtControls.ScrollView {
                width: rot.width
                height: rot.height - knapprad.height
                anchors.bottom: parent.bottom
                
                // Vising av søkeresultat som HTML
                WebView {
                    anchors.fill: parent
                    id: resultat
                    
                    // Gjer slik at teksten ikkje vert automatisk forminska
                    // før breidda på vindauget er *veldig* lita
                    experimental.preferredMinimumContentsWidth: 300
                } // Slutt WebView
            } // Slutt ScrollView
        } // Slutt rad
    } // Slutt kolonne
} // Slutt hovudvindauge
