# coding: utf-8

# Standardimportar for plasmoidar
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyKDE4.plasma import *
from PyKDE4 import plasmascript

# For sending av tekst frå og til ordbanken-programmet
from subprocess import Popen, PIPE

# Standard breidd og høgd på plasmoiden
BREIDD=700
HOGD=500

# Hovudprogrammet
class Ordbanken(plasmascript.Applet):
  def __init__(self,parent, args=None):
    plasmascript.Applet.__init__(self,parent)

  def init(self):
    # Har ingen innstillingar brukaren kan endra
    self.setHasConfigurationInterface(False)

    # Ymse ting for utsjånad
    self.theme = Plasma.Svg(self)
    self.theme.setImagePath("widgets/background")
    self.setBackgroundHints(Plasma.Applet.DefaultBackground)
    self.setAspectRatioMode(Plasma.IgnoreAspectRatio)

    # Plasser elementa nedover
    self.layout = QGraphicsLinearLayout(Qt.Vertical, self.applet)

    # Nettlesarkomponent
    self.webView = Plasma.WebView(self.applet)
    self.webView.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding)

    # Skrivefelt
    self.skrivefelt=Plasma.LineEdit(self.applet)
    self.skrivefelt.nativeWidget().setClearButtonShown(True)
    self.skrivefelt.nativeWidget().setClickMessage(u"Skriv inn ordet du vil sjå bøyinga til"); 

    # Ikon
    ikon = Plasma.IconWidget(self.applet)
    ikon.setIcon("ordbanken")
    ikon.setMaximumHeight(self.skrivefelt.preferredHeight());

    # Ei «rad» som inneheld toppelementa
    vassLayout = QGraphicsLinearLayout(Qt.Horizontal)
    vassLayout.addItem(ikon)
    vassLayout.addItem(self.skrivefelt)

    # Køyr søket når brukaren trykker på «Enter»
    QObject.connect(self.skrivefelt, SIGNAL("returnPressed()"), self.nyTekst)

    # Legg til dei to elementa
    self.layout.addItem(vassLayout)
    self.layout.addItem(self.webView)

    # Teikn opp vindauget
    self.setLayout(self.layout)
    self.resize(BREIDD, HOGD)

  # Slå opp i ordbanken og vis resultatet
  def nyTekst(self):

    # Hent tekst frå skrivefelt, og gjer om til UTF-8-bytefølgjer
    tekst = unicode( self.skrivefelt.text().toUtf8(), "utf-8")
    if tekst != "":
      # Kommandolinjekomponentane å køyra (fleire i framtida?)
      argument = ["ordbanken", "--html"]

      # Legg til søkeordet
      argument.append("--")
      argument += [elem for elem in tekst.split()]

      # Køyr ordbanken-programmet
      ordbanken = Popen((argument), stdout=PIPE, stderr=PIPE)
      returverdi = ordbanken.wait()

      # Oppdater HTML-komponenten
      HTML = unicode( ordbanken.stdout.read(), "utf-8" )
      self.webView.setHtml(HTML)

# Lag ordbank-plasmoiden
def CreateApplet(parent):
      return Ordbanken(parent)
