#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import os, sys
## Import Psyco if available :
try:
	import psyco
	#psyco.log()
	psyco.profile()
except ImportError:
	pass
	
## Searching for Python GTK2 in WIN32 systems (untested) :
if sys.platform.startswith( "win" ):
	## Fetchs gtk2 path from registry
	import _winreg
	import msvcrt
	try:
		k = _winreg.OpenKey( _winreg.HKEY_LOCAL_MACHINE, "Software\\GTK\\2.0" )
	except EnvironmentError:
		print "You must install the Gtk+ 2.2 Runtime Environment to run this program"
		while not msvcrt.kbhit():
			pass
		sys.exit( 1 )
	else:    
		gtkdir = _winreg.QueryValueEx( k, "Path" )
		os.environ['PATH'] += ";%s/lib;%s/bin" % ( gtkdir[0], gtkdir[0] )
import pygtk
pygtk.require( "2.0" )
import gtk, gtk.glade

from code.app import *
from code.config import *
from code.sub import *

app = app( config() )
app.load_glade_interface()

#global app

try: filename = sys.argv[1]
except: filename = ""

if filename != "":
	app.load_sub( filename )
else:
	app.new_sub()


app.connect_gtk_widgets()
app.get_widget( "topwin" ).show_all()
gtk.main()

