#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import re
from values import *

class time:
	def __init__( self, str="0:00:00.00" ):
		
		if ( str != "0:00:00.00" ) and ( str.count("") == 11 ):
			pattern = re.compile( "(\d{1}):(\d{2}):(\d{2}).(\d{2})" )
			thistime = pattern.search( str )
			if ( thistime != None ):
				( self.h, self.m, self.s, self.r ) = thistime.groups()
				self.h = int( self.h )
				self.m = int( self.m )
				self.s = int( self.s )
				self.r = int( self.r )
		else:
			self.h = 0
			self.m = 0
			self.s = 0
			self.r = 0
		return
	
	def __str__( self ):
		return "%01d:%02d:%02d.%02d" % ( self.h, self.m, self.s, self.r )
		
	def __add__( a, b ):
		c = time()
		c.h = a.h + b.h
		c.m = a.m + b.m
		c.s = a.s + b.s
		c.r = a.r + b.r
		
		while c.m >= 60:
			c.h += 1
			c.m -= 60
		while c.s >= 60:
			c.m += 1
			c.s -= 60
		while c.r >= 100:
			c.s += 1
			c.r -= 100
		
		return c

	def __sub__( a, b ):
		c = time()
		if b > a:
			c.h = a.h - b.h
			c.m = a.m - b.m
			c.s = a.s - b.s
			c.r = a.r - b.r
	
			if c.r < 0:
				c.r += 100
				c.s -= 1
			if c.s < 0:
				c.s += 60
				c.m -= 1
			if c.m < 0:
				c.m += 60
				c.h -= 1
		# if
		return c

	def __eq__( a, b ):
		if ( a.h == b.h ) and ( a.m == b.m ) and ( a.s == b.s ) and ( a.r == b.r ):
			return TRUE
		return FALSE

	def __cmp__( a, b ):
		if a == b:
			return 0
		elif b.h > a.h:
			return 1
		elif b.m > a.m:
			return 1
		elif b.s > a.s:
			return 1
		elif b.r > a.r:
			return 1
		return -1
	
