#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import string, re
import gettext

from values import *
from sub import *
#from callbacks import *


#
# FIXME : we should do some cleanup here !
#		Eg: should determine what script to save by the file ext (.ssa, .ass, etc.)
#			it would be better & easier.
#		We should have add a list box in the file-selector :
#			- Determine type from extension
#			- Sub Station Alpha (SSA)
#			- Advanced Sub Station Alpha (ASS)
#			- etc.  


def on_new_activate( self, app ):
	app.sub.set_filename( "" )
	app.sub.set_new( app )


def on_open_activate( self, app ):
	txt = _("Select a script to open")
	app.set_status( txt + "..." )
	fs_open = gtk.FileSelection( txt + " :" )
	fs_open.show_fileop_buttons()
	fs_open.set_select_multiple( gtk.FALSE )
	fs_open.ok_button.connect( 'clicked', fs_open_ok, app, fs_open )
	fs_open.cancel_button.connect( 'clicked', fs_cancel, app, fs_open, _("Opening a script : operation canceled.") )
	fs_open.show()


def on_save_activate( self, app ):
	filename = app.sub.get_filename() 
	if ( filename == "" ):
		fs_save = gtk.FileSelection( _("Select a script to save to :") )
		fs_save.show_fileop_buttons()
		fs_save.set_select_multiple( gtk.FALSE )
		fs_save.ok_button.connect( 'clicked', fs_save_ok, app, fs_save )
		fs_save.cancel_button.connect( 'clicked', fs_cancel, app, fs_save, _("Saving canceled.") )
		fs_save.show()
	else:
		if not re.search( ".ass$", filename ) == None:
			app.sub.save_ass( app )
		else:
			app.sub.save( app )
		app.set_status( _("Script saved as : ") + filename )

# FIXME: if we cancel the process, we lose the filename :
#			Maybe we should use sth like sub.tmp_filename and 
#			only set sub.filename AFTER the load/save...
def on_save_as_activate( self, app ):
	app.sub.set_filename( "" )
	on_save_activate( self, app )

# ENH: Should not exists, we should save the file according to the ext. (ssa, ass, etc.) : done.
# DEPRECATED
def on_export_ass_activate( self, app ):
	if app.sub.get_filename() == "":
		fs_save = gtk.FileSelection( _("Select a script to export to...") )
		fs_save.show_fileop_buttons()
		fs_save.set_select_multiple( gtk.FALSE )
		fs_save.ok_button.connect( 'clicked', fs_save_ass_ok, app, fs_save )
		fs_save.cancel_button.connect( 'clicked', fs_cancel, app, fs_save, _("Saving Canceled.") )
		fs_save.show()
	else:
		filename = app.sub.save_ass( app )
		app.set_status( _("Script exported as : ") + filename )


def fs_open_ok( self, app, fs ):
	filename = fs.get_filename()
	fs_cancel( self, app, fs, '' )
	app.sub.set_filename( filename )
	load_script( app )


def load_script( app ):
	filename = app.sub.get_filename()
	app.set_status( _("Opening script : %s...") % filename )
	is_ass = re.search( ".ass$", filename )
	is_sub = re.search( ".sub$", filename )
	if not is_ass == None:
		app.sub.load_ass( app )
	if not is_sub == None:
		app.sub.load_sub( app )
	else:
		app.sub.load( app )
	app.sub.set_names( app )
	app.sub.set_styles( app )
	app.set_status( _("Script %s openned.") % filename )



# FIXME : should verify if file already exists and ask for overwriting it !
def fs_save_ass_ok( self, app, fs ):
	app.sub.set_filename( fs.get_filename() )
	fs_cancel( self, app, fs, "" )
	on_export_ass_activate( self, app )


# FIXME : should verify if file already exists and ask for overwriting it !
def fs_save_ok( self, app, fs ):
	app.sub.set_filename( fs.get_filename() )
	fs_cancel( self, app, fs, "" )
	on_save_activate( self, app )


def fs_cancel( self, app, fs, txt ):
	fs.hide()
	del fs
	fs = None
	app.set_status( txt )

