#! /usr/bin/env python
#
# the Orange Slice -- a GTK+ based subtitle script editor.
# Copyright (C) 2003 Julien PORTALIER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
import os, sys
from values import *

class config:
	def __init__( self ): 
		self.app_name = 'orange-slice'
		self.app_homedir = os.path.dirname( os.path.realpath( sys.argv[0] ) )
		self.glade_dir = 'interface'
		self.glade_skin = 'orange-slice.glade'
		self.glade_file = os.path.join( self.app_homedir, self.glade_dir, self.glade_skin )
		self.locales_dir = os.path.join( self.app_homedir, 'po' )
		self.endline = LF
		self.colors = colors()
		return
	
	def set_endline( self, endline ):
		self.endline = endline 
	def get_endline( self ):
		return self.endline
	
class colors:
	def __init__( self ):
		self.fg = "#000000"
		self.fg_notime = "#000066"
		self.fg_overlap = "#660000"
		self.bg = "#ffffff"
		self.bg_com = "#eeeeee"
		return
