<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/
?>
<form method="post">
    <label>Description: <input type="text" name="taskDescription"/></label>
    <input type="submit" name="addTaskSubmit" value="Add Task" />
</form>
<br/>

<?php
    include('functions/tasklist_func.php');

    if(isset($_POST['addTaskSubmit']))
    {
        try
        {
            addTask($_POST['taskDescription']);
        }
        catch(Exception $addTaskException)
        {
            echo 'Error: Unable to add task!<br/>';
            echo 'System Error: '.$addTaskException->getMessage().'<br/><br/>';
        }
    }

    else if(isset($_POST['taskOperationSubmit']) && isset($_POST['selectedTask']))
    {
        if($_POST['selectTaskOperation'] == 'delete')
        {
            $conn->beginTransaction();
            try
            {
                deleteTask($_POST['selectedTask']);
                $conn->commit();
            }
            catch(Exception $performOperationOnTaskException)
            {
                $conn->rollback();
                echo 'Error: Unable to delete task!<br/>';
                echo 'System Error: '.$performOperationOnTaskException->getMessage().'<br/><br/>';
            }
        }
        else if($_POST['selectTaskOperation'] == 'edit')
        {
            echo '<meta http-equiv="Refresh" content="0; URL=index.php?menu=advanced&site=taskedit&taskid='.$_POST['selectedTask'].'">';
        }
    }

    try
    {
        getTasks();
    }
    catch(Exception $getTasksException)
    {
        echo 'Error: Unable to get Tasks!<br/>';
        echo 'System Error: '.$getTasksException->getMessage().'<br/><br/>';
    }
?>
