<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

    include('functions/taskedit_func.php');
    if(isset($_POST['addOperationSubmit']))
    {
        try
        {
            if($_POST['selectOperation'] == 'poweroff')
            {
                addOperationShutdown($_GET['taskid'], 'poweroff');
            }
            else if($_POST['selectOperation'] == 'reboot')
            {
                addOperationShutdown($_GET['taskid'], 'reboot');
            }
        }
        catch(Exception $addOperationShutdownException)
        {
            echo 'Error: Unable to add shutdown operation!<br/>';
            echo 'System Error: '.$addOperationShutdownException->getMessage().'<br/><br/>';
        }
    }
    else if(isset($_POST['operationDeleteSubmit']))
    {
        try
        {
            deleteOperation($_POST['selectedOperations']);
        }
        catch(Exception $deleteOperationException)
        {
            echo 'Error: Unable to delete operation!<br/>';
            echo 'System Error: '.$deleteOperationException->getMessage().'<br/><br/>';
        }
    }
    try
    {
    getOperations($_GET['taskid']);
    }
    catch(Exception $getOperationsException)
    {
        echo 'Error: Unable to get operations!<br/>';
        echo 'System Error: '.$getOperationsException->getMessage().'<br/><br/>';
    }
?>

<br/>

<form method="post">
    <select name="selectOperation" size="1">
        <option value="poweroff">Shutdown</option>
        <option value="reboot">Reboot</option>
    </select>
    <input type="submit" name="addOperationSubmit" value="Add Operation" />
</form>
