<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

require('functions/version_func.php');
?>
<fieldset>
	<legend>System</legend>
	<table class="overview">
		<colgroup>
			<col width="30%" />
			<col width="70%" />
		</colgroup>
		<tbody>
			<tr>
				<td>Hostname:</td>
				<td><?php system("uname -n"); ?></td>
			</tr>
			<tr>
				<td>Kernel:</td>
				<td><?php system("uname -sr"); ?></td>
			</tr>
			<tr>
				<td>Processor:</td>
				<td><?php system("sed -n -e 's/model name[ \t]*: //p' /proc/cpuinfo"); ?></td>
			</tr>
			<tr>
				<td>Load Average:</td>
				<td><?php system("cut -d' ' -f1-3 /proc/loadavg"); ?></td>
			</tr>
			<tr>
				<td>Memory:</td>
				<td><?php system("sed -n -e 's/MemFree: *//p' /proc/meminfo"); ?> / <?php system("sed -n -e 's/MemTotal: *//p' /proc/meminfo"); ?> free</td>
			</tr>
			<tr>
				<td>Swap:</td>
				<td><?php system("sed -n -e 's/SwapFree: *//p' /proc/meminfo"); ?> / <?php system("sed -n -e 's/SwapTotal: *//p' /proc/meminfo"); ?> free</td>
			</tr>
			<tr>
				<td>Disk:</td>
				<td><?php system("df -h /data | tail -1"); ?> free</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<fieldset>
	<legend>Software</legend>
	<table class="overview">
		<tbody>
			<tr>
				<td>Version:</td>
				<td><?php echo VERSION_LONG_STR; ?></td>
			</tr>
		</tbody>
	</table>
</fieldset>

