<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getImages()
{
    echo '<form method="POST" action="">';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Image ID</u></b></td>';
    echo '<td><b><u>Image Name</u></b></td>';
    echo '<td><b><u>Image Size [MiB]</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $images = Doctrine_Query::create()->from('Image')->execute();

    foreach($images as $image)
    {
        echo '<tr>';
        echo '<td><input type="checkbox" name="selectedImages[]" value="'.$image->id.'"/></td>';
        echo '<td>'.$image->id.'</td>';
        echo '<td>'.$image->name.'</td>';
        $imageDisks = Doctrine_Query::create()->from('ImageDisk')->where('image_id='.$image->id)->execute();
        foreach($imageDisks as $imageDisk)
        {
		    $imageSize = 0;
            $partitions = Doctrine_Query::create()->from('ImagePartition')->where('image_disk_id='.$imageDisk->id)->addWhere('image_size is not NULL')->execute();
            foreach($partitions as $partition)
            {
                $imageSize += $partition->image_size;
            }
        }
        echo '<td>'.floor($imageSize/1024/1024).'</td>';
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
    echo '<br/>';
    echo '<br/>';
    echo '<input type="text" name="selectedName" />';
    echo '<input type="submit" value="Change Name" name="changeNameSubmit" />';
    echo '<b> Warning:</b> Can only be used when one image is selected!';
    echo '<br>';
    echo '<br>';
    echo '<input type="submit" value="Delete Images" name="deleteImagesSubmit" />';
    echo '<b> Warning:</b> All associated tasks and their operations will be deleted!';
    echo '</form>';
}

function changeImageName($imageIds, $imageName)
{
    if(count($imageIds) == 1)
    {
        $image = Doctrine_Query::create()->from('Image')->where('id='.$imageIds[0])->execute();
        $image[0]->name = $imageName;
        $image[0]->save();
    }
    else
    {
        throw new Exception('Zero or more than one images selected! Imagename can only be changed for one image!');
    }
}

function deleteImages($imageIds)
{
    for($i=0; $i<count($imageIds); $i++)
    {
        $image = Doctrine_Query::create()->from('Image')->where('id='.$imageIds[$i])->execute();

        $imageDisks = Doctrine_Query::create()->from('ImageDisk')->where('image_id='.$image[0]->id)->execute();
        foreach($imageDisks as $imageDisk)
        {
            $partitions = Doctrine_Query::create()->from('Partition')->where('Partition.partitiontable_id='.$imageDisk->partitiontable_id)->execute();
            foreach($partitions as $partition)
            {
                $imagePartition = Doctrine_Query::create()->from('ImagePartition')->where('partition_id='.$partition->id)->execute();
                $imageOperations = Doctrine_Query::create()->from('OperationImage')->where('image_partition_id='.$imagePartition[0]->id)->execute();
                foreach($imageOperations as $imageOperation)
                {
                    $operation = Doctrine_Query::create()->from('Operation')->where('Operation.id='.$imageOperation->id)->execute();
                    $task = Doctrine_Query::create()->from('Task')->where('id='.$operation[0]->task_id)->execute();
                    $operationsForTask = Doctrine_Query::create()->from('Operation')->where('Operation.task_id='.$task[0]->id)->execute();

                    Doctrine_Query::create()->delete()->from('HostTask')->where('task_id='.$task[0]->id)->execute();

                    foreach($operationsForTask as $operationForTask)
                    {
                        if($operationForTask->type == 'image')
                        {
                            $op = Doctrine_Query::create()->from('OperationImage')->where('OperationImage.id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        else if($operationForTask->type == 'partition')
                        {
                            $op = Doctrine_Query::create()->from('OperationPartition')->where('id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        else if($operationForTask->type == 'shutdown')
                        {
                            $op = Doctrine_Query::create()->from('OperationShutdown')->where('id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        Doctrine_Query::create()->delete()->from('Operation')->where('id='.$operationForTask->id)->execute();
                    }
                }
                Doctrine_Query::create()->delete()->from('Task')->where('id='.$task[0]->id)->execute();

                $imagePart = Doctrine_Query::create()->from('ImagePartition')->addWhere('partition_id='.$partition->id)->execute();
                $imagePart->delete();
                $partMbr = Doctrine_Query::create()->from('PartitionMbr')->addWhere('id='.$partition->id)->execute();
                $partMbr->delete();
                Doctrine_Query::create()->delete('Partition')->addWhere('id='.$partition->id)->execute();
            }

            $partitionOperations = Doctrine_Query::create()->from('OperationPartition')->where('partitiontable_id='.$imageDisk->partitiontable_id)->execute();
            foreach($partitionOperations as $partitionOperation)
            {
                $operation = Doctrine_Query::create()->from('Operation')->where('Operation.id='.$partitionOperation->id)->execute();
                $task = Doctrine_Query::create()->from('Task')->where('id='.$operation[0]->task_id)->execute();
                $operationsForTask = Doctrine_Query::create()->from('Operation')->where('Operation.task_id='.$task[0]->id)->execute();
                foreach($operationsForTask as $operationForTask)
                {
                        if($operationForTask->type == 'image')
                        {
                            $op = Doctrine_Query::create()->from('OperationImage')->where('id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        else if($operationForTask->type == 'partition')
                        {
                            $op = Doctrine_Query::create()->from('OperationPartition')->where('id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        else if($operationForTask->type == 'shutdown')
                        {
                            $op = Doctrine_Query::create()->from('OperationShutdown')->where('id='.$operationForTask->id)->execute();
                            $op->delete();
                        }
                        Doctrine_Query::create()->delete()->from('Operation')->where('id='.$operationForTask->id)->execute();
                }
                Doctrine_Query::create()->delete()->from('Task')->where('id='.$task[0]->id)->execute();
            }

            Doctrine_Query::create()->delete()->from('ImageDisk')->where('id='.$imageDisk->id)->execute();

            $partMbr = Doctrine_Query::create()->from('PartitiontableMbr')->where('id='.$imageDisk->partitiontable_id)->execute();
            $partMbr->delete();
            Doctrine_Query::create()->delete()->from('Partitiontable')->where('id='.$imageDisk->partitiontable_id)->execute();
        }
        Doctrine_Query::create()->delete()->from('Image')->where('id='.$image[0]->id)->execute();

        $output = null;
        $return = null;
        exec('sudo -u '.WRAPPERUSER.' '.WRAPPERSCRIPT.' delimage '.$image[0]->id, $output, $return);
        if($return != 0)
        {
            throw new Exception('Unable to delete image from filesystem!');
        }
    }
}
?>
