<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getHostDetails($hostId)
{
    echo '<fieldset id="full">';
    echo '<legend>General Information</legend>';
    echo '<table align="center">';
    echo '<tbody>';

    $host = Doctrine_Query::create()->from('Host')->where('id='.$hostId)->execute();

    echo '<tr>';
    echo '<td>Host ID:</td>';
    echo '<td>'.$host[0]->id.'</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Hostname:</td>';
    echo '<td>'.$host[0]->hostname.'</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Host IP:</td>';
    echo '<td>'.$host[0]->ip.'</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Host MAC:</td>';
    echo '<td>'.$host[0]->mac.'</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Serial number:</td>';
    echo '<td>'.$host[0]->serial_no.'</td>';
    $group = Doctrine_Query::create()->from('Group')->where('id='.$host[0]->group_id)->execute();
    if(count($group) == 0)
    {
        $groupname = 'None';
    }
    else
    {
        $groupname = $group[0]->name;
    }
    echo '<tr>';
    echo '<td>Group:</td>';
    echo '<td>'.$groupname.'</td>';
    echo '</tr>';
    echo '</tr>';
    if($host[0]->running == 1)
    {
        $running = 'yes';
    }
    else if($host[0]->running == 0)
    {
        $running = 'no';
    }
    echo '<tr>';
    echo '<td>Running:</td>';
    echo '<td>'.$running.'</td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Last boot time:</td>';
    echo '<td>'.$host[0]->last_boot_time.'</td>';
    echo '</tr>';

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';

    echo '<br/>';

    echo '<fieldset id="full">';
    echo '<legend>CPUS</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    //echo '<tr>';
    //echo '<td colspan="4"><b><u>CPUS</u></b></td>';
    //echo '</tr>';
    echo '<td><b><u>Processor number</u></b></td>';
    echo '<td><b><u>Vendor</u></b></td>';
    echo '<td><b><u>Model</u></b></td>';
    echo '<td><b><u>Speed [Mhz]</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $cpus = Doctrine_Query::create()->select('DeviceCpu.processor_no, DeviceCpu.vendor_id, DeviceCpu.model_name, DeviceCpu.mhz')->from('DeviceCpu, Device')->where('Device.host_id='.$hostId)->addwhere('Device.type="cpu"')->addwhere('Device.id=DeviceCpu.id')->execute();

    foreach($cpus as $cpu)
    {
        echo '<tr>';
        echo '<td>'.$cpu->processor_no.'</td>';
        echo '<td>'.$cpu->vendor_id.'</td>';
        echo '<td>'.$cpu->model_name.'</td>';
        echo '<td>'.$cpu->mhz.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';

    echo '<br/>';

    echo '<fieldset id="full">';
    echo '<legend>RAMS</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    //echo '<tr>';
    //echo '<td><b><u>RAMS</u></b></td>';
    //echo '</tr>';
    echo '<tr>';
    echo '<td><b><u>Size [MiB]</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

     $rams = Doctrine_Query::create()->select('DeviceRam.size')->from('DeviceRam, Device')->where('Device.host_id='.$hostId)->addwhere('Device.type="ram"')->addwhere('Device.id=DeviceRam.id')->execute();

    foreach($rams as $ram)
    {
        echo '<tr>';
        echo '<td>'.floor($ram->size/1024).'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';

    echo '<br/>';

    echo '<fieldset id="full">';
    echo '<legend>DISKS</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    //echo '<tr>';
    //echo '<td colspan="4"><b><u>Disks</u></b></td>';
    //echo '</tr>';
    echo '<tr>';
    echo '<td><b><u>Address</u></b></td>';
    echo '<td><b><u>Size [MiB]</u></b></td>';
    echo '<td><b><u>Model number</u></b></td>';
    echo '<td><b><u>Serial number</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $devices = Doctrine_Query::create()->from('Device')->where('host_id='.$hostId)->addwhere('type="harddisk"')->execute();

    foreach($devices as $device)
    {
        $disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$device->id)->execute();

        echo '<tr>';
        echo '<td>'.$disk[0]->address.'</td>';
        echo '<td>'.floor($disk[0]->size/1024/1024).'</td>';
        echo '<td>'.$disk[0]->model_no.'</td>';
        echo '<td>'.$disk[0]->serial_no.'</td>';
        echo '</tr>';

        echo '<tr>';
        echo '<td><b>Partitions:</b></td>';
        echo '<td>&nbsp;</td>';
        echo '<td>&nbsp;</td>';
        echo '<td>&nbsp;</td>';
        echo '</tr>';

        $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$disk[0]->partitiontable_id)->execute();

        echo '<tr>';
        echo '<td><u>Number</u></td>';
        echo '<td><u>Record type</u></td>';
        echo '<td><u>File system</u></td>';
        echo '<td><u>Operating System</u></td>';
        echo '</tr>';

        foreach($partitions as $partition)
        {
            $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();

            echo '<tr>';
            echo '<td>'.$partitionMbr[0]->no.'</td>';
            echo '<td>'.$partitionMbr[0]->record_type.'</td>';
            echo '<td>'.$partition->fs.'</td>';
            echo '<td>'.$partition->os.'</td>';
            echo '</tr>';
        }

        echo '<tr>';
        echo '<td colspan="5">&nbsp;</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';

    echo '<br/>';

    echo '<fieldset id="full">';
    echo '<legend>TASKS</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    //echo '<tr>';
    //echo '<td colspan="4"><b><u>TASKS</u></b></td>';
    //echo '</tr>';
    echo '<tr>';
    echo '<td><b><u>Description</u></b></td>';
    echo '<td><b><u>Percentage</u></b></td>';
    echo '<td><b><u>Speed</u></b></td>';
    echo '<td><b><u>Status</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $tasksForHost = Doctrine_Query::create()->from('HostTask')->where('HostTask.host_id='.$hostId)->execute();

    foreach($tasksForHost as $taskForHost)
    {
        $taskDescription = Doctrine_Query::create()->from('Task')->where('id='.$taskForHost->task_id)->execute();
        echo '<tr>';
        echo '<td>'.$taskDescription[0]->description.'</td>';
        echo '<td>'.$taskForHost->percentage.'</td>';
        echo '<td>'.$taskForHost->speed.'</td>';
        echo '<td>'.$taskForHost->status.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset';
}

function getChangeableDetails($hostId)
{
    $host = Doctrine_Query::create()->from('Host')->where('id='.$hostId)->execute();

    echo '<form method="POST" action="">';
    echo '<table>';
    echo '<tr>';
    echo '<td colspan="2"><b>Change Details</b></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Hostname:</td>';
    echo '<td><input type="text" name="hostname" value="'.$host[0]->hostname.'" /></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>IP Address:</td>';
    echo '<td><input type="text" name="IPAddress" value="'.$host[0]->ip.'" /></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>MAC Address:</td>';
    echo '<td><input type="text" name="MACAddress" value="'.$host[0]->mac.'" /></td>';
    echo '</tr>';
    echo '<tr>';
    echo '<td>Serial Number:</td>';
    echo '<td><input type="text" name="serialNumber" value="'.$host[0]->serial_no.'" /></td>';
    echo '</tr>';
    echo '</table>';
    echo '<input type="submit" name="changeDetailsSubmit" value="Change" />';
    echo '</form>';
}

function changeDetails($hostId, $hostname, $IPAddress, $MACAddress, $serialNumber)
{
    $host = Doctrine_Query::create()->from('Host')->where('id='.$hostId)->execute();
    
    $host[0]->hostname = $hostname;
    $host[0]->ip = $IPAddress;
    $host[0]->mac = $MACAddress;
    $host[0]->serial_no = $serialNumber;
    $host[0]->save();
}
?>
