<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getImageDisks()
{
    echo '<form method="POST" action="?menu=deploy&site=deploy2">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Name</u></b></td>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Address</u></b></td>';
    echo '<td>&nbsp;</td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $imageDisks = Doctrine_Query::create()->from('ImageDisk')->execute();

    foreach($imageDisks as $imageDisk)
    {
        $image = Doctrine_Query::create()->from('Image')->where('id='.$imageDisk->image_id)->execute();

        echo '<tr>';
        echo '<td><input type="radio" name="selectedImageDisk" value="'.$imageDisk->id.'"/></td>';
        echo '<td>'.$image[0]->name.'</td>';
        echo '<td>&nbsp;</td>';
        echo '<td>'.$imageDisk->address.'</td>';
        echo '<td>&nbsp;</td>';
        echo '</tr>';

        echo '<tr>';
        echo '<td>&nbsp;</td>';
        echo '<td colspan="4" align="left"><b>Partitions:</b></td>';
        echo '</tr>';

        $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$imageDisk->partitiontable_id)->execute();

        echo '<tr>';
        echo '<td>&nbsp;</td>';
        echo '<td><u>Number</u></td>';
        echo '<td><u>Record type</u></td>';
        echo '<td><u>File system</u></td>';
        echo '<td><u>Operating System</u></td>';
        echo '</tr>';

        foreach($partitions as $partition)
        {
            $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();

            echo '<tr>';
            echo '<td>&nbsp;</td>';
            echo '<td>'.$partitionMbr[0]->no.'</td>';
            echo '<td>'.$partitionMbr[0]->record_type.'</td>';
            echo '<td>'.$partition->fs.'</td>';
            echo '<td>'.$partition->os.'</td>';
            echo '</tr>';
        }

        echo '<tr>';
        echo '<td colspan="5">&nbsp;</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<input type="submit" name="selectDiskSubmit" value="Next" />';
    echo '</form>';

}

function getHosts($imageDisk, $group)
{
    echo '<form method="POST" action="?menu=deploy&site=deploy3">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Boot ID</u></b></td>';
    echo '<td><b><u>Hostname</u></b></td>';
    echo '<td><b><u>IP Address</u></b></td>';
    echo '<td><b><u>MAC Address</u></b></td>';
    echo '<td><b><u>Running</u></b></td>';
    echo '<td><b><u>Boottime</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    if($group == 'running')
    {
        $hosts = Doctrine_Query::create()->from('Host')->where('running=1')->execute();
    }
    else
    {
        $hosts = Doctrine_Query::create()->from('Host')->where('group_id='.$group)->execute();
    }

    foreach($hosts as $host)
    {
        echo '<tr>';
        if($group == 'running')
        {
            echo '<td><input type="checkbox" name="selectedHosts[]" value="'.$host->id.'"/></td>';
        }
        else
        {
            if($host->running == 1)
            {
                echo '<td><input type="checkbox" name="selectedHosts[]" value="'.$host->id.'" checked/></td>';
            }
            else
            {
                echo '<td><input type="checkbox" name="selectedHosts[]" value="'.$host->id.'" /></td>';
            }
        }
        echo '<td>'.$host->id.'</td>';
        echo '<td>'.$host->hostname.'</td>';
        echo '<td>'.$host->ip.'</td>';
        echo '<td>'.$host->mac.'</td>';
        if($host->running == 1)
        {
            echo '<td>yes</td>';
        }
        else if($host->running == 0)
        {
            echo '<td>no</td>';
        }
        echo '<td>'.$host->last_boot_time.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<input type="hidden" name="selectedImageDisk" value="'.$imageDisk.'" />';
    echo '<input type="submit" name="selectHostsSubmit" value="Next" />';
    echo '</form>';
}

function getHostDisks($hostIds, $imageDiskId)
{
    $disks = Doctrine_Query::create()->select('DeviceHarddisk.address, MIN(DeviceHarddisk.size) as minsize')->from('DeviceHarddisk, Device, Host')->whereIn('Host.id', $hostIds)->addWhere('Device.host_id=Host.id')->addWhere('Device.id=DeviceHarddisk.id')->groupBy('DeviceHarddisk.address')->having('COUNT(DeviceHarddisk.id) = '.count($hostIds))->execute();

    $imageDiskSize = 0;
    $imagePartitions = Doctrine_Query::create()->from('ImagePartition')->where('image_disk_id='.$imageDiskId)->execute();
    foreach($imagePartitions as $imagePartition)
    {
        $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$imagePartition->partition_id)->execute();
        if($partitionMbr->record_type != 'extended')
        {
            $imageDiskSize += $imagePartition->size;
        }
    }

    echo '<b>Image Size:</b> ' . floor($imageDiskSize/1024/1024) . ' MiB';
    echo '<br/>';
    echo '<br/>';

    echo '<form method="POST" action="?menu=deploy&site=deploy4">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Address</u></b></td>';
    echo '<td><b><u>Minimal size [MiB]</u></b></td>';
    //echo '<td><b><u>Model number</u></b></td>';
    //echo '<td><b><u>Serial number</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    //$devices = Doctrine_Query::create()->from('Device')->where('host_id='.$hostIds[0])->addWhere('type="harddisk"')->execute();
    
    foreach($disks as $disk)
    {
        //$disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$device->id)->execute();

        if($disk->minsize > $imageDiskSize)
        {
            echo '<tr>';
            echo '<td><input type="radio" name="selectedDisk" value="'.$disk->address.'"/></td>';
        }
        else
        {
            echo '<tr class="not_available">';
            echo '<td><input type="radio" name="selectedDisk" value="'.$disk->address.'" disabled/></td>';
        }
        echo '<td>'.$disk->address.'</td>';
        echo '<td>'.floor($disk->minsize/1024/1024).'</td>';
        //echo '<td>'.$disk[0]->model_no.'</td>';
        //echo '<td>'.$disk[0]->serial_no.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<label>Operation after deployment: <select name="operationAfterDeployment">';
    echo '<option value="none">None</option>';
    echo '<option value="shutdown">Shutdown Clients</option>';
    echo '<option value="reboot">Reboot Clients</option>';
    echo '</select></label>';

    for($i=0;$i<count($hostIds);$i++)
    {
        echo '<input type="hidden" name="selectedHosts['.$i.']" value="'.$hostIds[$i].'"/>';
    }
    echo '<input type="hidden" name="selectedImageDisk" value="'.$imageDiskId.'"/>';
    echo '<input type="submit" name="selectDiskSubmit" value="Finish" />';
    echo '</form>';
}

function restoreImage($hostIds, $imageDiskId, $diskAddress, $operationAfterDeployment)
{
    $imageDisk = Doctrine_Query::create()->from('ImageDisk')->where('id='.$imageDiskId)->execute();
    $image = Doctrine_Query::create()->from('Image')->where('id='.$imageDisk->image_id)->execute();

    $task = new Task();
    $task->description = 'Restore '.$image[0]->name.' on '.$diskAddress.' ('.date("Ymd",time()).')';
    $maxTaskSequence = Doctrine_Query::create()->select('MAX(Task.sequence) as max_sequence')->from('Task')->execute();
    $maxTaskSeq = $maxTaskSequence[0]->max_sequence;
    $task->sequence = $maxTaskSeq + 1;
    $task->save();

        //$diskId = Doctrine_Query::create()->select('DeviceHarddisk.id')->from('DeviceHarddisk, Device')->where('DeviceHarddisk.address = ?',$diskAddress)->addWhere('Device.host_id='.$hostIds[$i])->addWhere('Device.id=DeviceHarddisk.id')->execute();
        //$disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$diskId[0]->id)->execute();

    $operationPartition = new OperationPartition();
    $operationPartition->partitiontable_id = $imageDisk[0]->partitiontable_id;
    $operationPartition->program = 'direct';
    $operationPartition->address = $diskAddress;
    $operationPartition->restore_bootloader = 1; 
    $operationPartition->restore_unused = 1;
    $operationPartition->task_id = $task->id;
    $maxOperationSequence = Doctrine_Query::create()->select('MAX(Operation.sequence) as max_sequence')->from('Operation')->where('Operation.task_id='.$task->id)->execute();
    $maxOperationSeq = $maxOperationSequence[0]->max_sequence;
    $operationPartition->sequence = $maxOperationSeq + 1;
    $operationPartition->type = 'partition';
    $operationPartition->save();

    $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$imageDisk[0]->partitiontable_id)->execute();

    foreach($partitions as $partition)
    {
        $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();

        if($partitionMbr->record_type != 'extended')
        {
            $imagePartition = Doctrine_Query::create()->from('ImagePartition')->where('partition_id='.$partition->id)->execute();

            $operationImage = new OperationImage();
            $operationImage->task_id = $task->id;
            //$maxOperationImageSequence = Doctrine_Query::create()->select('MAX(Operation.sequence) as max_sequence')->from('Operation')->where('Operation.task_id='.$task->id)->execute();
            //$maxOperationImageSeq = $maxOperationImageSequence[0]->max_sequence;
            $operationImage->sequence = $maxOperationSeq + 2;
            $operationImage->type = 'image';
            $operationImage->mode = 'restore';
            $operationImage->image_partition_id = $imagePartition[0]->id;
            $operationImage->address = $diskAddress.$partitionMbr[0]->no;
            $operationImage->transfer_mode = "multicast";
            $operationImage->save();
        }
    }

    if($operationAfterDeployment == 'shutdown' || $operationAfterDeployment == 'reboot')
    {
        $operationShutdown = new OperationShutdown();
        $operationShutdown->task_id = $task->id;
        $operationShutdown->sequence = $maxOperationSeq + 3;
        $operationShutdown->type = 'shutdown';
        if($operationAfterDeployment == 'poweroff')
        {
            $operationShutdown->mode = 'poweroff';
        }
        else if($operationAfterDeployment == 'reboot')
        {
            $operationShutdown->mode = 'reboot';
        }
        $operationShutdown->save();
    }

    for($i=0;$i<count($hostIds);$i++)
    {
        $hostTask = new HostTask();
        $hostTask->host_id = $hostIds[$i];
        $hostTask->task_id = $task->id;
        $hostTask->status = 'running';
        $hostTask->save();
    }
}

function getGroups($imageDisk, $activeGroup)
{
    $groups = Doctrine_Query::create()->from('Group')->execute();

    echo '<form method="post">';
    echo '<select name="selectedGroup" size="1">';
    if($activeGroup == 'running')
    {
        echo '<option value="running" selected>Running</option>';
    }
    else
    {
        echo '<option value="running" selected>Running</option>';
    }

    foreach($groups as $group)
    {
        if($activeGroup == $group->id)
        {
            echo '<option value="'.$group->id.'" selected>'.$group->name.'</option>';
        }
        else
        {
            echo '<option value="'.$group->id.'">'.$group->name.'</option>';
        }
    }

    echo '</select>';
    echo '<input type="hidden" name="selectedImageDisk" value="'.$imageDisk.'" />';
    echo '<input type="submit" name="selectGroupSubmit" value="Show" />';
    echo '</form>';    
}
?>
