<?php
/*
 This file is part of OpenClone.

 Copyright (C) 2009  Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

function getRunningHosts()
{
    echo '<form method="POST" action="?menu=create&amp;site=create2">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Boot ID</u></b></td>';
    echo '<td><b><u>Hostname</u></b></td>';
    echo '<td><b><u>IP Address</u></b></td>';
    echo '<td><b><u>MAC Address</u></b></td>';
    echo '<td><b><u>Boottime</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $hosts = Doctrine_Query::create()->from('Host')->where('running=1')->execute();

    foreach($hosts as $host)
    {
        echo '<tr>';
        echo '<td><input type="radio" name="selectedHost" value="'.$host->id.'"/></td>';
        echo '<td>'.$host->id.'</td>';
        echo '<td>'.$host->hostname.'</td>';
        echo '<td>'.$host->ip.'</td>';
        echo '<td>'.$host->mac.'</td>';
        echo '<td>'.$host->last_boot_time.'</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<input type="submit" name="selectHostSubmit" value="Next" />';
    echo '</form>';
}

function getHostDisks($hostId)
{
    echo '<form method="POST" action="?menu=create&site=create3">';

    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    echo '<tr>';
    echo '<td>&nbsp;</td>';
    echo '<td><b><u>Address</u></b></td>';
    echo '<td><b><u>Size [MiB]</u></b></td>';
    echo '<td><b><u>Model number</u></b></td>';
    echo '<td><b><u>Serial number</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $devices = Doctrine_Query::create()->from('Device')->where('host_id='.$hostId)->addwhere('type="harddisk"')->execute();

    foreach($devices as $device)
    {
        $disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$device->id)->execute();

        echo '<tr>';
        echo '<td><input type="radio" name="selectedDisk" value="'.$disk[0]->id.'"/></td>';
        echo '<td>'.$disk[0]->address.'</td>';
        echo '<td>'.floor($disk[0]->size/1024/1024).'</td>';
        echo '<td>'.$disk[0]->model_no.'</td>';
        echo '<td>'.$disk[0]->serial_no.'</td>';
        echo '</tr>';

        echo '<tr>';
        echo '<td>&nbsp;</td>';
        echo '<td colspan="4" align="left"><b>Partitions:</b></td>';
        echo '</tr>';

        $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$disk[0]->partitiontable_id)->execute();

        echo '<tr>';
        echo '<td>&nbsp;</td>';
        echo '<td><u>Number</u></td>';
        echo '<td><u>Record type</u></td>';
        echo '<td><u>File system</u></td>';
        echo '<td><u>Operating System</u></td>';
        echo '</tr>';

        foreach($partitions as $partition)
        {
            $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();

            echo '<tr>';
            echo '<td>&nbsp;</td>';
            echo '<td>'.$partitionMbr[0]->no.'</td>';
            echo '<td>'.$partitionMbr[0]->record_type.'</td>';
            echo '<td>'.$partition->fs.'</td>';
            echo '<td>'.$partition->os.'</td>';
            echo '</tr>';
        }

        echo '<tr>';
        echo '<td colspan="5">&nbsp;</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';

    echo '<br/>';

    echo '<input type="hidden" name="selectedHost" value="'.$hostId.'"/>';
    echo '<input type="submit" name="selectDiskSubmit" value="Next" />';
    echo '</form>';
}

function printSummary($hostId, $diskId)
{
    echo '<fieldset id="full">';
    echo '<legend>HOST</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    //echo '<tr>';
    //echo '<td colspan="5" align="center"><b><u>Host</u></b></td>';
    //echo '</tr>';
    echo '<tr>';
    echo '<td><b><u>Boot ID</u></b></td>';
    echo '<td><b><u>Hostname</u></b></td>';
    echo '<td><b><u>IP Address</u></b></td>';
    echo '<td><b><u>MAC Address</u></b></td>';
    echo '<td><b><u>Boottime</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $host = Doctrine_Query::create()->from('Host')->where('id='.$hostId)->execute();

    echo '<tr>';
    echo '<td>'.$host[0]->id.'</td>';
    echo '<td>'.$host[0]->hostname.'</td>';
    echo '<td>'.$host[0]->ip.'</td>';
    echo '<td>'.$host[0]->mac.'</td>';
    echo '<td>'.$host[0]->last_boot_time.'</td>';
    echo '</tr>';

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';

    echo '<br/>';

    echo '<fieldset id="full">';
    echo '<legend>DISK</legend>';
    echo '<table id="hostlisting">';
    echo '<thead id="hostlisting">';
    //echo '<tr>';
    //echo '<td colspan="4" align="center"><b><u>Disk</u></b></td>';
    //echo '</tr>';
    echo '<tr>';
    echo '<td><b><u>Address</u></b></td>';
    echo '<td><b><u>Size [MiB]</u></b></td>';
    echo '<td><b><u>Model number</u></b></td>';
    echo '<td><b><u>Serial number</u></b></td>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';

    $disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$diskId)->execute();

    echo '<tr>';
    echo '<td>'.$disk[0]->address.'</td>';
    echo '<td>'.floor($disk[0]->size/1024/1024).'</td>';
    echo '<td>'.$disk[0]->model_no.'</td>';
    echo '<td>'.$disk[0]->serial_no.'</td>';
    echo '</tr>';

    echo '<tr>';
    echo '<td colspan="4" align="left"><b>Partitions:</b></td>';
    echo '</tr>';

    $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$disk[0]->partitiontable_id)->execute();

    echo '<tr>';
    echo '<td><u>Number</u></td>';
    echo '<td><u>Record type</u></td>';
    echo '<td><u>File system</u></td>';
    echo '<td><u>Operating System</u></td>';
    echo '</tr>';

    foreach($partitions as $partition)
    {
        $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();

        echo '<tr>';
        echo '<td>'.$partitionMbr[0]->no.'</td>';
        echo '<td>'.$partitionMbr[0]->record_type.'</td>';
        echo '<td>'.$partition->fs.'</td>';
        echo '<td>'.$partition->os.'</td>';
        echo '</tr>';
    }
    

    echo '</tbody>';
    echo '</table>';
    echo '</fieldset>';
}

function createImage($hostId, $diskId, $imageName, $operationAfterCreation, $imageCompression)
{
    $image = new Image();
    $image->name = $imageName;
    $image->save();

    $disk = Doctrine_Query::create()->from('DeviceHarddisk')->where('id='.$diskId)->execute();
 
    $partitionTable = Doctrine_Query::create()->from('Partitiontable')->where('id='.$disk[0]->partitiontable_id)->execute();
    $partitionTableMbr = Doctrine_Query::create()->from('PartitiontableMbr')->where('id='.$partitionTable[0]->id)->execute();

    $partitionTableMbrNew = new PartitiontableMbr();
    $partitionTableMbrNew->type = $partitionTable[0]->type;
    $partitionTableMbrNew->disk_signature = $partitionTableMbr[0]->disk_signature;
    $partitionTableMbrNew->bootloader = $partitionTableMbr[0]->bootloader;
    $partitionTableMbrNew->partitions = $partitionTableMbr[0]->partitions;
    $partitionTableMbrNew->extended = $partitionTableMbr[0]->extended;
    $partitionTableMbrNew->unused = $partitionTableMbr[0]->unused;
    $partitionTableMbrNew->save();

    $imageDisk = new ImageDisk();
    $imageDisk->image_id = $image->id;
    $imageDisk->partitiontable_id = $partitionTableMbrNew->id;
    $imageDisk->address = $disk[0]->address;
    $imageDisk->save();

    $task = new Task();
    $task->description = 'Backup '.$disk[0]->address.' on '.$imageName.' ('.date("Ymd",time()).')';
    $maxTaskSequence = Doctrine_Query::create()->select('MAX(Task.sequence) as max_sequence')->from('Task')->execute();
    $maxTaskSeq = $maxTaskSequence[0]->max_sequence;
    $task->sequence = $maxTaskSeq + 1;
    $task->save();

    $partitions = Doctrine_Query::create()->from('Partition')->where('partitiontable_id='.$partitionTable[0]->id)->execute();

    $maxOperationSequence = Doctrine_Query::create()->select('MAX(Operation.sequence) as max_sequence')->from('Operation')->where('Operation.task_id='.$task->id)->execute();
    $maxOperationSeq = $maxOperationSequence[0]->max_sequence;

    foreach($partitions as $partition)
    {
        $partitionMbr = Doctrine_Query::create()->from('PartitionMbr')->where('id='.$partition->id)->execute();
        
        if($partitionMbr[0]->record_type != 'extended')
        {
            $partitionMbrNew = new PartitionMbr();
            $partitionMbrNew->partitiontable_id = $partitionTableMbrNew->id;
            $partitionMbrNew->type = $partition->type;
            $partitionMbrNew->fs = $partition->fs;
            $partitionMbrNew->os = $partition->os;
            $partitionMbrNew->no = $partitionMbr[0]->no;
            $partitionMbrNew->record_type = $partitionMbr[0]->record_type;
            $partitionMbrNew->bootable = $partitionMbr[0]->bootable;
            $partitionMbrNew->partition_type = $partitionMbr[0]->partition_type;
            $partitionMbrNew->start_lba = $partitionMbr[0]->start_lba;
            $partitionMbrNew->sectors = $partitionMbr[0]->sectors;
            $partitionMbrNew->start_head = $partitionMbr[0]->start_head;
            $partitionMbrNew->start_sector = $partitionMbr[0]->start_sector;
            $partitionMbrNew->start_cylinder = $partitionMbr[0]->start_cylinder;
            $partitionMbrNew->end_head = $partitionMbr[0]->end_head;
            $partitionMbrNew->end_sector = $partitionMbr[0]->end_sector;
            $partitionMbrNew->end_cylinder = $partitionMbr[0]->end_cylinder;
            $partitionMbrNew->save();

            $imagePartition = new ImagePartition();
            $imagePartition->image_disk_id = $imageDisk->id;
            $imagePartition->partition_id = $partitionMbrNew->id;
            switch($partition->fs)
            {
                case 'ext2':
                case 'ext3':
                case 'ntfs':
                case 'reiserfs':
                case 'vfat':
                    $imagePartition->format = 'partimage';
                    $imagePartition->compression = $imageCompression;
                    break;

                case 'swap':
                    $imagePartition->format = 'directswap';
                    $imagePartition->compression = 'none';
                    break;

                default:
                    $imagePartition->format = 'dd';
                    $imagePartition->compression = $imageCompression;
            }
            $imagePartition->size = $disk[0]->sector_size * $partitionMbrNew->sectors;
            $imagePartition->save();

            $operationImage = new OperationImage();
            $operationImage->task_id = $task->id;
            //$maxOperationSequence = Doctrine_Query::create()->select('MAX(Operation.sequence) as max_sequence')->from('Operation')->where('Operation.task_id='.$task->id)->execute();
            //$maxOperationSeq = $maxOperationSequence[0]->max_sequence;
            $maxOperationSeq++;
            $operationImage->sequence = $maxOperationSeq;
            $operationImage->type = 'image';
            $operationImage->mode = 'backup';
            $operationImage->image_partition_id = $imagePartition->id;
            $operationImage->address = $imageDisk->address.$partitionMbrNew->no;
            $operationImage->transfer_mode = "unicast";
            $operationImage->save();
        }       
    }

    if($operationAfterCreation == 'shutdown' || $operationAfterCreation == 'reboot')
    {
        $operationShutdown = new OperationShutdown();
        $operationShutdown->task_id = $task->id;
        $maxOperationSeq++;
        $operationShutdown->sequence = $maxOperationSeq;
        $operationShutdown->type = 'shutdown';
        if($operationAfterCreation == 'shutdown')
        {
            $operationShutdown->mode = 'poweroff';
        }
        else if($operationAfterCreation == 'reboot')
        {
            $operationShutdown->mode = 'reboot';
        }
        $operationShutdown->save();
    }

    $hostTask = new HostTask();
    $hostTask->host_id = $hostId;
    $hostTask->task_id = $task->id;
    $hostTask->status = "running";
    $hostTask->save();
}    
?>
