#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from OpenCloneEngineService_services import *

class EngineClient(OpenCloneEngineServiceSOAPSOAP):
    def __init__(self, url):
        OpenCloneEngineServiceSOAPSOAP.__init__(self, url)
    
    def new_register_host(self):
        return registerRequest().new_host()
    
    def new_logon_host(self):
        return logonRequest().new_host()
    
    def new_host_cpu_device(self):
        return ns0.CPUDevice_Def('devices').pyclass()
    
    def new_host_ram_device(self):
        return ns0.RAMDevice_Def('devices').pyclass()
    
    def new_host_harddisk_device(self):
        return ns0.HardDiskDevice_Def('devices').pyclass()
    
    def new_logoff_hostid(self):
        return logoffRequest().new_hostid()
    
    def new_harddisk_mbr_partitiontable(self):
        return ns0.MBRPartitiontable_Def('partitiontable').pyclass()
    
    def new_partitiontable_mbr_partition(self):
        return ns0.MBRPartition_Def('parts').pyclass()
    
    def new_nextoperation_hostid(self):
        return nextOperationRequest().new_hostid()
    
    def new_statusupdate(self):
        return statusUpdateRequest().new_statusupdate()
