#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from ioctl import _IO, _IOR, _IOW

size_t = 4

# See linux/fs.h
BLKROSET   = _IO(0x12,93)   # set device read-only (0 = read-write)
BLKROGET   = _IO(0x12,94)   # get read-only status (0 = read_write)
BLKRRPART  = _IO(0x12,95)   # re-read partition table
BLKGETSIZE = _IO(0x12,96)   # return device size /512 (long *arg)
BLKFLSBUF  = _IO(0x12,97)   # flush buffer cache
BLKRASET   = _IO(0x12,98)   # set read ahead for block device
BLKRAGET   = _IO(0x12,99)   # get current read ahead setting
BLKFRASET  = _IO(0x12,100)  # set filesystem (mm/filemap.c) read-ahead
BLKFRAGET  = _IO(0x12,101)  # get filesystem (mm/filemap.c) read-ahead
BLKSECTSET = _IO(0x12,102)  # set max sectors per request (ll_rw_blk.c)
BLKSECTGET = _IO(0x12,103)  # get max sectors per request (ll_rw_blk.c)
BLKSSZGET  = _IO(0x12,104)  # get block device sector size

BLKGETLASTSECT = _IO(0x12,108) # get last sector of block device

BLKBSZGET    = _IOR(0x12,112,size_t)
BLKBSZSET    = _IOW(0x12,113,size_t)
BLKGETSIZE64 = _IOR(0x12,114,size_t) # return device size in bytes (u64 *arg)


# See hdparm: hdparm.h
HDIO_DRIVE_CMD          = 0x031f
HDIO_DRIVE_RESET        = 0x031c
HDIO_DRIVE_TASK         = 0x031e
HDIO_DRIVE_TASKFILE     = 0x031d
HDIO_GETGEO             = 0x0301
HDIO_GETGEO_BIG         = 0x0330
HDIO_GET_32BIT          = 0x0309
HDIO_GET_ACOUSTIC       = 0x030f
HDIO_GET_BUSSTATE       = 0x031a
HDIO_GET_DMA            = 0x030b
HDIO_GET_IDENTITY       = 0x030d
HDIO_GET_KEEPSETTINGS   = 0x0308
HDIO_GET_MULTCOUNT      = 0x0304
HDIO_GET_NOWERR         = 0x030a
HDIO_GET_QDMA           = 0x0305
HDIO_GET_UNMASKINTR     = 0x0302
HDIO_OBSOLETE_IDENTITY  = 0x0307
HDIO_SCAN_HWIF          = 0x0328
HDIO_SET_32BIT          = 0x0324
HDIO_SET_ACOUSTIC       = 0x032c
HDIO_SET_BUSSTATE       = 0x032d
HDIO_SET_DMA            = 0x0326
HDIO_SET_KEEPSETTINGS   = 0x0323
HDIO_SET_MULTCOUNT      = 0x0321
HDIO_SET_NOWERR         = 0x0325
HDIO_SET_PIO_MODE       = 0x0327
HDIO_SET_QDMA           = 0x032e
HDIO_SET_UNMASKINTR     = 0x0322
HDIO_SET_WCACHE         = 0x032b
HDIO_TRISTATE_HWIF      = 0x031b
HDIO_UNREGISTER_HWIF    = 0x032a
CDROM__SPEED            = 0x5322


FORMAT_HD_GEOMETRY = 'BBHL'
FORMAT_HD_BIG_GEOMETRY = 'BBIL'
