#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

import os

def universal_readline(file, **kw):
    str = ''
    if 'seekable' not in kw:
        try:
            file.seek(1, os.SEEK_CUR)
            file.seek(-1, os.SEEK_CUR)
            kw['seekable'] = True
        
        except IOError:
            kw['seekable'] = False
    
    while True:
        c = file.read(1)
        if c == '':
            break
        
        str += c
        if c == '\n':
            break
        
        elif c == '\r':
            if kw['seekable']:
                c = file.read(1)
                if c == '\n':
                    str += c
                
                else:
                    file.seek(-1, os.SEEK_CUR)
            
            break
    
    return str

def universal_readline_iter(file, **kw):
    while True:
        line = universal_readline(file, **kw)
        if line == '':
            break
        
        yield line
