SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

CREATE SCHEMA IF NOT EXISTS `openclone` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ;
USE `openclone`;

-- -----------------------------------------------------
-- Table `openclone`.`group`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`group` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(255) NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB
AUTO_INCREMENT = 1;


-- -----------------------------------------------------
-- Table `openclone`.`host`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`host` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `group_id` INT UNSIGNED NULL DEFAULT NULL ,
  `mac` CHAR(12) NOT NULL ,
  `ip` VARCHAR(15) NULL DEFAULT NULL ,
  `hostname` VARCHAR(255) NULL DEFAULT NULL ,
  `serial_no` VARCHAR(255) NULL ,
  `running` TINYINT(1) NOT NULL ,
  `last_boot_time` TIMESTAMP NULL DEFAULT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `group_id` (`group_id` ASC) ,
  CONSTRAINT `hosts_ibfk_1`
    FOREIGN KEY (`group_id` )
    REFERENCES `openclone`.`group` (`id` ))
ENGINE = InnoDB
AUTO_INCREMENT = 1;


-- -----------------------------------------------------
-- Table `openclone`.`device`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`device` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `host_id` INT UNSIGNED NOT NULL ,
  `type` ENUM('cpu', 'ram', 'harddisk') NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `host_id` (`host_id` ASC) ,
  CONSTRAINT `devices_ibfk_1`
    FOREIGN KEY (`host_id` )
    REFERENCES `openclone`.`host` (`id` ))
ENGINE = InnoDB
AUTO_INCREMENT = 1;


-- -----------------------------------------------------
-- Table `openclone`.`task`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`task` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `sequence` INT UNSIGNED NOT NULL ,
  `description` VARCHAR(255) NULL DEFAULT NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB
AUTO_INCREMENT = 1;


-- -----------------------------------------------------
-- Table `openclone`.`operation`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`operation` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `task_id` INT UNSIGNED NOT NULL ,
  `sequence` INT UNSIGNED NOT NULL ,
  `type` ENUM('partition', 'image', 'shutdown') NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `task_id` (`id` ASC, `task_id` ASC) ,
  CONSTRAINT `operations_ibfk_1`
    FOREIGN KEY (`task_id` )
    REFERENCES `openclone`.`task` (`id` ))
ENGINE = InnoDB
AUTO_INCREMENT = 1;


-- -----------------------------------------------------
-- Table `openclone`.`host_task`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`host_task` (
  `host_id` INT UNSIGNED NOT NULL ,
  `task_id` INT UNSIGNED NOT NULL ,
  `status` ENUM('running','finished','failed') NOT NULL ,
  `cur_operation_id` INT UNSIGNED NULL DEFAULT NULL ,
  `next_operation_id` INT UNSIGNED NULL DEFAULT NULL ,
  `percentage` FLOAT UNSIGNED NULL ,
  `speed` VARCHAR(255) NULL ,
  PRIMARY KEY (`host_id`, `task_id`) ,
  INDEX `fk_host_task_operation_cur` (`task_id` ASC, `cur_operation_id` ASC) ,
  INDEX `fk_host_task_operation_next` (`task_id` ASC, `next_operation_id` ASC) ,
  CONSTRAINT `host_task_ibfk_1`
    FOREIGN KEY (`task_id` )
    REFERENCES `openclone`.`task` (`id` ),
  CONSTRAINT `host_task_ibfk_2`
    FOREIGN KEY (`host_id` )
    REFERENCES `openclone`.`host` (`id` ),
  CONSTRAINT `fk_host_task_operation_cur`
    FOREIGN KEY (`task_id` , `cur_operation_id` )
    REFERENCES `openclone`.`operation` (`task_id` , `id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_host_task_operation_next`
    FOREIGN KEY (`task_id` , `next_operation_id` )
    REFERENCES `openclone`.`operation` (`task_id` , `id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`partitiontable`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`partitiontable` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `type` ENUM('mbr') NOT NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`image`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`image` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(255) NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`image_disk`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`image_disk` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `image_id` INT UNSIGNED NOT NULL ,
  `partitiontable_id` INT UNSIGNED NULL ,
  `address` VARCHAR(255) NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_image_disk_partitiontable` (`partitiontable_id` ASC) ,
  INDEX `fk_image_disk_image` (`image_id` ASC) ,
  CONSTRAINT `fk_image_disk_partitiontable`
    FOREIGN KEY (`partitiontable_id` )
    REFERENCES `openclone`.`partitiontable` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_image_disk_image`
    FOREIGN KEY (`image_id` )
    REFERENCES `openclone`.`image` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`partition`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`partition` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `partitiontable_id` INT UNSIGNED NOT NULL ,
  `type` ENUM('mbr') NOT NULL ,
  `fs` VARCHAR(255) NULL ,
  `os` VARCHAR(255) NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_partition_partitiontable` (`partitiontable_id` ASC) ,
  CONSTRAINT `fk_partition_partitiontable`
    FOREIGN KEY (`partitiontable_id` )
    REFERENCES `openclone`.`partitiontable` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`image_partition`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`image_partition` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `image_disk_id` INT UNSIGNED NOT NULL ,
  `partition_id` INT UNSIGNED NOT NULL ,
  `format` ENUM('dd','partimage','directswap') NOT NULL ,
  `compression` ENUM('none','gzip', 'lzo') NOT NULL ,
  `size` BIGINT UNSIGNED NULL ,
  `minimum_size` BIGINT UNSIGNED NULL ,
  `image_size` BIGINT UNSIGNED NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_image_partition_image_disk` (`image_disk_id` ASC) ,
  INDEX `fk_image_partition_partition` (`partition_id` ASC) ,
  CONSTRAINT `fk_image_partition_image_disk`
    FOREIGN KEY (`image_disk_id` )
    REFERENCES `openclone`.`image_disk` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_image_partition_partition`
    FOREIGN KEY (`partition_id` )
    REFERENCES `openclone`.`partition` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`operation_image`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`operation_image` (
  `id` INT UNSIGNED NOT NULL ,
  `mode` ENUM('backup','restore') NOT NULL ,
  `image_partition_id` INT UNSIGNED NOT NULL ,
  `address` VARCHAR(255) NOT NULL ,
  `transfer_mode` ENUM('unicast','multicast') NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_operation_image_image_partition` (`image_partition_id` ASC) ,
  CONSTRAINT `image_operations_ibfk_1`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`operation` (`id` ),
  CONSTRAINT `fk_operation_image_image_partition`
    FOREIGN KEY (`image_partition_id` )
    REFERENCES `openclone`.`image_partition` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`operation_shutdown`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`operation_shutdown` (
  `id` INT UNSIGNED NOT NULL ,
  `mode` ENUM('poweroff','reboot','exit') NOT NULL ,
  PRIMARY KEY (`id`) ,
  CONSTRAINT `shutdown_operations_ibfk_1`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`operation` (`id` ))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`device_harddisk`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`device_harddisk` (
  `id` INT UNSIGNED NOT NULL ,
  `address` VARCHAR(255) NOT NULL ,
  `partitiontable_id` INT UNSIGNED NULL ,
  `size` BIGINT UNSIGNED NOT NULL ,
  `sector_size` SMALLINT UNSIGNED NOT NULL ,
  `model_no` VARCHAR(255) NULL ,
  `serial_no` VARCHAR(255) NULL ,
  `firmware_rev` VARCHAR(255) NULL ,
  `wwn` BIGINT UNSIGNED NULL ,
  `cylinder` MEDIUMINT UNSIGNED NULL ,
  `heads` TINYINT UNSIGNED NULL ,
  `sectors` TINYINT UNSIGNED NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_devices_harddisk_devices` (`id` ASC) ,
  INDEX `fk_device_harddisk_partitiontable` (`partitiontable_id` ASC) ,
  CONSTRAINT `fk_devices_harddisk_devices`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`device` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_device_harddisk_partitiontable`
    FOREIGN KEY (`partitiontable_id` )
    REFERENCES `openclone`.`partitiontable` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`partitiontable_mbr`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`partitiontable_mbr` (
  `id` INT UNSIGNED NOT NULL ,
  `disk_signature` TINYBLOB NOT NULL ,
  `bootloader` BLOB NOT NULL ,
  `partitions` TINYBLOB NOT NULL ,
  `extended` BLOB NULL ,
  `unused` MEDIUMBLOB NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_partitiontable_mbr_partitiontable` (`id` ASC) ,
  CONSTRAINT `fk_partitiontable_mbr_partitiontable`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`partitiontable` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`device_cpu`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`device_cpu` (
  `id` INT UNSIGNED NOT NULL ,
  `processor_no` TINYINT UNSIGNED NOT NULL ,
  `vendor_id` VARCHAR(255) NULL ,
  `model_name` VARCHAR(255) NULL ,
  `mhz` FLOAT UNSIGNED NULL ,
  `bogomips` FLOAT UNSIGNED NULL ,
  `cache` SMALLINT UNSIGNED NULL ,
  `core_id` TINYINT UNSIGNED NULL ,
  `cpu_cores` TINYINT UNSIGNED NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_device_cpu_device` (`id` ASC) ,
  CONSTRAINT `fk_device_cpu_device`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`device` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`device_ram`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`device_ram` (
  `id` INT UNSIGNED NOT NULL ,
  `size` INT UNSIGNED NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_device_ram_device` (`id` ASC) ,
  CONSTRAINT `fk_device_ram_device`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`device` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`user` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(255) NOT NULL ,
  `password` CHAR(40) NOT NULL ,
  `last_login` DATETIME NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`operation_partition`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`operation_partition` (
  `id` INT UNSIGNED NOT NULL ,
  `partitiontable_id` INT UNSIGNED NOT NULL ,
  `program` ENUM('direct') NOT NULL ,
  `address` VARCHAR(255) NOT NULL ,
  `restore_bootloader` TINYINT(1) NOT NULL ,
  `restore_unused` TINYINT(1) NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_operation_partition_operation` (`id` ASC) ,
  INDEX `fk_operation_partition_partitiontable` (`partitiontable_id` ASC) ,
  CONSTRAINT `fk_operation_partition_operation`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`operation` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_operation_partition_partitiontable`
    FOREIGN KEY (`partitiontable_id` )
    REFERENCES `openclone`.`partitiontable` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `openclone`.`partition_mbr`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `openclone`.`partition_mbr` (
  `id` INT UNSIGNED NOT NULL ,
  `no` TINYINT UNSIGNED NOT NULL ,
  `record_type` ENUM('primary','extended','logical') NOT NULL ,
  `bootable` TINYINT(1) NOT NULL ,
  `partition_type` TINYINT UNSIGNED NOT NULL ,
  `start_lba` INT UNSIGNED NOT NULL ,
  `sectors` INT UNSIGNED NOT NULL ,
  `start_head` TINYINT UNSIGNED NOT NULL ,
  `start_sector` TINYINT UNSIGNED NOT NULL ,
  `start_cylinder` SMALLINT UNSIGNED NOT NULL ,
  `end_head` TINYINT UNSIGNED NOT NULL ,
  `end_sector` TINYINT UNSIGNED NOT NULL ,
  `end_cylinder` SMALLINT UNSIGNED NOT NULL ,
  INDEX `fk_partition_mbr_partition` (`id` ASC) ,
  PRIMARY KEY (`id`) ,
  CONSTRAINT `fk_partition_mbr_partition`
    FOREIGN KEY (`id` )
    REFERENCES `openclone`.`partition` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
