#
# $Id: webservice.py 86 2009-05-02 19:02:20Z lxp $
#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

from ZSI.ServiceContainer import ServiceContainer, SOAPRequestHandler
#import ZSI.wstools.logging
import logging
from SocketServer import ThreadingMixIn

logger = logging.getLogger('webservice')

#class PythonLogger(ZSI.wstools.logging.ILogger):
#    logger = None
#    
#    def __init__(self, msg):
#        self.logger = logging.getLogger('webservice')
#    
#    def warning(self, msg, *args, **kw):
#        self.logger.warning(msg % args)
#    
#    def debug(self, msg, *args, **kw):
#        self.logger.debug(msg % args)
#    
#    def error(self, msg, *args, **kw):
#        self.logger.error(msg % args)

class CustomSOAPRequestHandler(SOAPRequestHandler):
    def log_message(self, format, *args):
        logger.debug('Client %s - %s' % (self.address_string(), format % args))

# http://groups.google.com/group/pywebsvcs/browse_thread/thread/48aa5fe99eb1164b/2383497dac5da9e1
class ThreadedServiceContainer(ThreadingMixIn, ServiceContainer):
    '''Multithreaded version of ServiceContainer.
    '''
    pass

class Webservice:
    def __init__(self, listen, port):
        #ZSI.wstools.logging.setLoggerClass(PythonLogger)
        self.sc = ThreadedServiceContainer((listen, port), RequestHandlerClass=CustomSOAPRequestHandler)
        #engineserv = OpenCloneEngineServiceImpl()
        #engineserv_intf = OpenCloneEngineService(impl=engineserv, auth_method_name="authorize")
        #self.sc.setNode(engineserv_intf, url="/OpenCloneEngineService")
    
    def addService(self, service):
        self.sc.setNode(service)
    
    def run(self):
        self.sc.serve_forever()
