/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import java.io.*;

public class RWFile
{
public static void main(String[] arg) 
	{
	try
	{
	WFile wf = new WFile("test.txt");
	wf.writeString("I");
	wf.writeString("SQRT(I)");
	wf.writeln("I*I");
	
	for (int i=0;i<15;i++)
		{
		wf.print(i+" ");
		wf.writeDouble(Math.sqrt(i));
		wf.writelnDouble(i*i);
		}
	wf.close();
	}
	catch(IOException evt)
		{
		}	  
	
	try
	{
	RFile rf = new RFile("test.txt");
	int cpt=0;
	while (rf.nextToken() != StreamTokenizer.TT_EOF)
		{
		if (rf.ttype == rf.TT_NUMBER) System.out.print(rf.nval);
		if (rf.ttype == rf.TT_WORD) System.out.print(rf.sval);
		System.out.print((cpt==2)?"\n" : " ");
		cpt = (cpt+1)%3;
		}	
	}
	catch(IOException evt)
		{
		}	  
	}

}

