/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class Projectile
	{
	
	public static void main(String[] arg)
	{
	// Rsolution des quations de de la dynamique pour un projectile

	Problem pb = new Problem(4);	//problme en dimension 2
	RK ts = new RK();		// avec la mthode de RungeKutta classique
	
	DVect cd = new DVect(4);	// vecteur pour la condition initiale
	
	ts.setNstep(1000);		//nombre de pas en temps : 1000
	ts.set(0,10);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(4);
			public int dim() { return 4; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,x.get(2));		//x'(t,x,y,z,w) = z		
				y.set(1,x.get(3));				//y'(t,x,y,z,w) = w
				y.set(2,-x.get(2));				//z'(t,x,y,z,w) = 0
				y.set(3,-9.81-x.get(3));				//w'(t,x,y,z,w) = -9.81
			return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	
	// on rsoud les quations de la dynamique
	double[][] sol = new double[5][1000];
	cd.set(0,0);
	cd.set(1,0);
	cd.set(2,10*Math.cos(Math.PI*0.33));
	cd.set(3,10*Math.sin(Math.PI*0.33));
	pb.setInit(cd);
	pb.solve();
	sol=pb.toArray();
	
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D(true);
	jf.setTitle("Mouvement d'un projectile - Opale-ODE 0.1");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-1,5,0,5);
	jf.getPack2D().add(repere,"repere");
	GData2D gsol = new GData2D(repere);
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
		gsol.set(1000,sol[1],sol[2]);
		jf.getPack2D().add(gsol,"sol");
	jf.show();
	
	
	
	}

}
